/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jersey2;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Provider
public class InstrumentedResourceMethodApplicationListener
implements ApplicationEventListener,
ModelProcessor {
    private final MetricRegistry metrics;
    private ConcurrentMap<Method, Timer> timers = new ConcurrentHashMap<Method, Timer>();
    private ConcurrentMap<Method, Meter> meters = new ConcurrentHashMap<Method, Meter>();
    private ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters = new ConcurrentHashMap<Method, ExceptionMeterMetric>();

    public InstrumentedResourceMethodApplicationListener(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            this.registerMetricsForModel(event.getResourceModel());
        }
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return resourceModel;
    }

    @Override
    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        this.registerMetricsForModel(subResourceModel);
        return subResourceModel;
    }

    private void registerMetricsForModel(ResourceModel resourceModel) {
        for (Resource resource : resourceModel.getResources()) {
            Timed classLevelTimed = this.getClassLevelAnnotation(resource, Timed.class);
            Metered classLevelMetered = this.getClassLevelAnnotation(resource, Metered.class);
            ExceptionMetered classLevelExceptionMetered = this.getClassLevelAnnotation(resource, ExceptionMetered.class);
            for (ResourceMethod method : resource.getAllMethods()) {
                this.registerTimedAnnotations(method, classLevelTimed);
                this.registerMeteredAnnotations(method, classLevelMetered);
                this.registerExceptionMeteredAnnotations(method, classLevelExceptionMetered);
            }
            for (Resource childResource : resource.getChildResources()) {
                Timed classLevelTimedChild = this.getClassLevelAnnotation(childResource, Timed.class);
                Metered classLevelMeteredChild = this.getClassLevelAnnotation(childResource, Metered.class);
                ExceptionMetered classLevelExceptionMeteredChild = this.getClassLevelAnnotation(childResource, ExceptionMetered.class);
                for (ResourceMethod method : childResource.getAllMethods()) {
                    this.registerTimedAnnotations(method, classLevelTimedChild);
                    this.registerMeteredAnnotations(method, classLevelMeteredChild);
                    this.registerExceptionMeteredAnnotations(method, classLevelExceptionMeteredChild);
                }
            }
        }
    }

    @Override
    public RequestEventListener onRequest(RequestEvent event) {
        ChainedRequestEventListener listener = new ChainedRequestEventListener(new RequestEventListener[]{new TimerRequestEventListener(this.timers), new MeterRequestEventListener(this.meters), new ExceptionMeterRequestEventListener(this.exceptionMeters)});
        return listener;
    }

    private <T extends Annotation> T getClassLevelAnnotation(Resource resource, Class<T> annotationClazz) {
        Class<?> clazz;
        T annotation = null;
        Iterator<Class<?>> iterator = resource.getHandlerClasses().iterator();
        while (iterator.hasNext() && (annotation = (T)(clazz = iterator.next()).getAnnotation(annotationClazz)) == null) {
        }
        return annotation;
    }

    private void registerTimedAnnotations(ResourceMethod method, Timed classLevelTimed) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelTimed != null) {
            this.timers.putIfAbsent(definitionMethod, InstrumentedResourceMethodApplicationListener.timerMetric(this.metrics, method, classLevelTimed));
            return;
        }
        Timed annotation = definitionMethod.getAnnotation(Timed.class);
        if (annotation != null) {
            this.timers.putIfAbsent(definitionMethod, InstrumentedResourceMethodApplicationListener.timerMetric(this.metrics, method, annotation));
        }
    }

    private void registerMeteredAnnotations(ResourceMethod method, Metered classLevelMetered) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelMetered != null) {
            this.meters.putIfAbsent(definitionMethod, InstrumentedResourceMethodApplicationListener.meterMetric(this.metrics, method, classLevelMetered));
            return;
        }
        Metered annotation = definitionMethod.getAnnotation(Metered.class);
        if (annotation != null) {
            this.meters.putIfAbsent(definitionMethod, InstrumentedResourceMethodApplicationListener.meterMetric(this.metrics, method, annotation));
        }
    }

    private void registerExceptionMeteredAnnotations(ResourceMethod method, ExceptionMetered classLevelExceptionMetered) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelExceptionMetered != null) {
            this.exceptionMeters.putIfAbsent(definitionMethod, new ExceptionMeterMetric(this.metrics, method, classLevelExceptionMetered));
            return;
        }
        ExceptionMetered annotation = definitionMethod.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            this.exceptionMeters.putIfAbsent(definitionMethod, new ExceptionMeterMetric(this.metrics, method, annotation));
        }
    }

    private static Timer timerMetric(MetricRegistry registry, ResourceMethod method, Timed timed) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(timed.name(), timed.absolute(), method, new String[0]);
        return registry.timer(name);
    }

    private static Meter meterMetric(MetricRegistry registry, ResourceMethod method, Metered metered) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(metered.name(), metered.absolute(), method, new String[0]);
        return registry.meter(name);
    }

    protected static String chooseName(String explicitName, boolean absolute, ResourceMethod method, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name(method.getInvocable().getDefinitionMethod().getDeclaringClass(), explicitName);
        }
        return MetricRegistry.name(MetricRegistry.name(method.getInvocable().getDefinitionMethod().getDeclaringClass(), method.getInvocable().getDefinitionMethod().getName()), suffixes);
    }

    private static class ChainedRequestEventListener
    implements RequestEventListener {
        private final RequestEventListener[] listeners;

        private ChainedRequestEventListener(RequestEventListener ... listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onEvent(RequestEvent event) {
            for (RequestEventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }

    private static class ExceptionMeterRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters;

        public ExceptionMeterRequestEventListener(ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters) {
            this.exceptionMeters = exceptionMeters;
        }

        @Override
        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                ExceptionMeterMetric metric;
                ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
                ExceptionMeterMetric exceptionMeterMetric = metric = method != null ? (ExceptionMeterMetric)this.exceptionMeters.get(method.getInvocable().getDefinitionMethod()) : null;
                if (metric != null && (metric.cause.isAssignableFrom(event.getException().getClass()) || event.getException().getCause() != null && metric.cause.isAssignableFrom(event.getException().getCause().getClass()))) {
                    metric.meter.mark();
                }
            }
        }
    }

    private static class MeterRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, Meter> meters;

        public MeterRequestEventListener(ConcurrentMap<Method, Meter> meters) {
            this.meters = meters;
        }

        @Override
        public void onEvent(RequestEvent event) {
            Meter meter;
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START && (meter = (Meter)this.meters.get(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod())) != null) {
                meter.mark();
            }
        }
    }

    private static class TimerRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, Timer> timers;
        private Timer.Context context = null;

        public TimerRequestEventListener(ConcurrentMap<Method, Timer> timers) {
            this.timers = timers;
        }

        @Override
        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START) {
                Timer timer = (Timer)this.timers.get(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod());
                if (timer != null) {
                    this.context = timer.time();
                }
            } else if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_FINISHED && this.context != null) {
                this.context.close();
            }
        }
    }

    private static class ExceptionMeterMetric {
        public final Meter meter;
        public final Class<? extends Throwable> cause;

        public ExceptionMeterMetric(MetricRegistry registry, ResourceMethod method, ExceptionMetered exceptionMetered) {
            String name = InstrumentedResourceMethodApplicationListener.chooseName(exceptionMetered.name(), exceptionMetered.absolute(), method, "exceptions");
            this.meter = registry.meter(name);
            this.cause = exceptionMetered.cause();
        }
    }
}

