/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.dropwizard.views.View;
import io.dropwizard.views.ViewRenderException;
import io.dropwizard.views.ViewRenderer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class ViewMessageBodyWriter
implements MessageBodyWriter<View> {
    private static final Logger logger = LoggerFactory.getLogger(MessageBodyWriter.class);
    public static final String TEMPLATE_ERROR_MSG = "<html><head><title>Template Error</title></head><body><h1>Template Error</h1><p>Something went wrong rendering the page</p></body></html>";
    @Context
    private HttpHeaders headers;
    private final Iterable<ViewRenderer> renderers;
    private final MetricRegistry metricRegistry;

    @Deprecated
    public ViewMessageBodyWriter(MetricRegistry metricRegistry) {
        this(metricRegistry, ServiceLoader.load(ViewRenderer.class));
    }

    public ViewMessageBodyWriter(MetricRegistry metricRegistry, Iterable<ViewRenderer> viewRenderers) {
        this.metricRegistry = metricRegistry;
        this.renderers = viewRenderers;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return View.class.isAssignableFrom(type);
    }

    public long getSize(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Timer.Context context = this.metricRegistry.timer(MetricRegistry.name(t.getClass(), (String[])new String[]{"rendering"})).time();
        try {
            Iterator<ViewRenderer> iterator = this.renderers.iterator();
            while (iterator.hasNext()) {
                ViewRenderer renderer = iterator.next();
                if (renderer.isRenderable(t)) {
                    renderer.render(t, this.detectLocale(this.headers), entityStream);
                    return;
                }
            }
            throw new ViewRenderException("Unable to find a renderer for " + t.getTemplateName());
        }
        catch (Exception e) {
            logger.debug("Template Error", (Throwable)e);
            throw new WebApplicationException(Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)TEMPLATE_ERROR_MSG).build());
        }
        finally {
            context.stop();
        }
    }

    private Locale detectLocale(HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        for (Locale locale : languages) {
            if (locale.toString().contains("*")) continue;
            return locale;
        }
        return Locale.getDefault();
    }
}

