/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import io.dropwizard.testing.ConfigOverrideRandomPorts;
import io.dropwizard.testing.ConfigOverrideValue;
import java.util.function.Supplier;

public abstract class ConfigOverride {
    static final String DEFAULT_PREFIX = "dw.";

    public static ConfigOverride config(String key, String value) {
        return new ConfigOverrideValue(DEFAULT_PREFIX, key, () -> value);
    }

    public static ConfigOverride config(String propertyPrefix, String key, String value) {
        return new ConfigOverrideValue(propertyPrefix, key, () -> value);
    }

    public static ConfigOverride config(String key, Supplier<String> value) {
        return new ConfigOverrideValue(DEFAULT_PREFIX, key, value);
    }

    public static ConfigOverride config(String propertyPrefix, String key, Supplier<String> value) {
        return new ConfigOverrideValue(propertyPrefix, key, value);
    }

    public static ConfigOverride randomPorts() {
        return new ConfigOverrideRandomPorts(DEFAULT_PREFIX);
    }

    public static ConfigOverride randomPorts(String propertyPrefix) {
        return new ConfigOverrideRandomPorts(propertyPrefix);
    }

    public abstract void addToSystemProperties();

    public abstract void removeFromSystemProperties();
}

