/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.jersey.validation.ConstraintViolationExceptionMapper;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.logging.BootstrapLogging;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.validation.Validator;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ResourceTestRule
implements TestRule {
    private final Set<Object> singletons;
    private final Set<Class<?>> providers;
    private final Map<String, Object> properties;
    private final ObjectMapper mapper;
    private final Validator validator;
    private final TestContainerFactory testContainerFactory;
    private JerseyTest test;

    public static Builder builder() {
        return new Builder();
    }

    private ResourceTestRule(Set<Object> singletons, Set<Class<?>> providers, Map<String, Object> properties, ObjectMapper mapper, Validator validator, TestContainerFactory testContainerFactory) {
        this.singletons = singletons;
        this.providers = providers;
        this.properties = properties;
        this.mapper = mapper;
        this.validator = validator;
        this.testContainerFactory = testContainerFactory;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public Client client() {
        return this.test.client();
    }

    public JerseyTest getJerseyTest() {
        return this.test;
    }

    public Statement apply(final Statement base, Description description) {
        final ResourceTestRule rule = this;
        final String ruleId = String.valueOf(rule.hashCode());
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    ResourceTestRule.this.test = new JerseyTest(){

                        protected TestContainerFactory getTestContainerFactory() {
                            return ResourceTestRule.this.testContainerFactory;
                        }

                        protected DeploymentContext configureDeployment() {
                            ResourceTestResourceConfig resourceConfig = new ResourceTestResourceConfig(ruleId, rule);
                            return ServletDeploymentContext.builder((Application)resourceConfig).initParam("javax.ws.rs.Application", ResourceTestResourceConfig.class.getName()).initParam("io.dropwizard.testing.junit.resourceTestRuleId", ruleId).build();
                        }

                        protected void configureClient(ClientConfig config) {
                            JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
                            jsonProvider.setMapper(ResourceTestRule.this.mapper);
                            config.register((Object)jsonProvider);
                        }
                    };
                    ResourceTestRule.this.test.setUp();
                    base.evaluate();
                }
                finally {
                    ResourceTestResourceConfig.RULE_ID_TO_RULE.remove(ruleId);
                    if (ResourceTestRule.this.test != null) {
                        ResourceTestRule.this.test.tearDown();
                    }
                }
            }
        };
    }

    static {
        BootstrapLogging.bootstrap();
    }

    public static class ResourceTestResourceConfig
    extends DropwizardResourceConfig {
        private static final String RULE_ID = "io.dropwizard.testing.junit.resourceTestRuleId";
        private static final Map<String, ResourceTestRule> RULE_ID_TO_RULE = Maps.newHashMap();

        public ResourceTestResourceConfig(String ruleId, ResourceTestRule resourceTestRule) {
            super(true, new MetricRegistry());
            RULE_ID_TO_RULE.put(ruleId, resourceTestRule);
            this.configure(resourceTestRule);
        }

        public ResourceTestResourceConfig(@Context ServletConfig servletConfig) {
            super(true, new MetricRegistry());
            String ruleId = servletConfig.getInitParameter(RULE_ID);
            Preconditions.checkNotNull((Object)ruleId);
            ResourceTestRule resourceTestRule = RULE_ID_TO_RULE.get(ruleId);
            Preconditions.checkNotNull((Object)resourceTestRule);
            this.configure(resourceTestRule);
        }

        private void configure(ResourceTestRule resourceTestRule) {
            this.register(new ConstraintViolationExceptionMapper());
            for (Class clazz : resourceTestRule.providers) {
                this.register(clazz);
            }
            this.property("jersey.config.server.response.setStatusOverSendError", "true");
            for (Map.Entry entry : resourceTestRule.properties.entrySet()) {
                this.property((String)entry.getKey(), entry.getValue());
            }
            this.register(new JacksonMessageBodyProvider(resourceTestRule.mapper, resourceTestRule.validator));
            for (Object object : resourceTestRule.singletons) {
                this.register(object);
            }
        }
    }

    public static class Builder {
        private final Set<Object> singletons = Sets.newHashSet();
        private final Set<Class<?>> providers = Sets.newHashSet();
        private final Map<String, Object> properties = Maps.newHashMap();
        private ObjectMapper mapper = Jackson.newObjectMapper();
        private Validator validator = Validators.newValidator();
        private TestContainerFactory testContainerFactory = new InMemoryTestContainerFactory();

        public Builder setMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setValidator(Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder addResource(Object resource) {
            this.singletons.add(resource);
            return this;
        }

        public Builder addProvider(Class<?> klass) {
            this.providers.add(klass);
            return this;
        }

        public Builder addProvider(Object provider) {
            this.singletons.add(provider);
            return this;
        }

        public Builder addProperty(String property, Object value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder setTestContainerFactory(TestContainerFactory factory) {
            this.testContainerFactory = factory;
            return this;
        }

        public ResourceTestRule build() {
            return new ResourceTestRule(this.singletons, this.providers, this.properties, this.mapper, this.validator, this.testContainerFactory);
        }
    }
}

