/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.metrics.StringMatchingStrategy;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

class RegexStringMatchingStrategy
implements StringMatchingStrategy {
    private final LoadingCache<String, Pattern> patternCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String regex) throws Exception {
            return Pattern.compile(regex);
        }
    });

    RegexStringMatchingStrategy() {
    }

    @Override
    public boolean containsMatch(ImmutableSet<String> matchExpressions, String metricName) {
        for (String regexExpression : matchExpressions) {
            if (!((Pattern)this.patternCache.getUnchecked((Object)regexExpression)).matcher(metricName).matches()) continue;
            return true;
        }
        return false;
    }
}

