/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.factory;

import gluu.scim2.client.DummyClient;
import gluu.scim2.client.TestModeScimClient;
import gluu.scim2.client.UmaScimClient;
import gluu.scim2.client.rest.ClientSideService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.xdi.oxauth.model.util.SecurityProviderUtility;

public class ScimClientFactory {
    private static Class<ClientSideService> defaultInterface;

    public static <T> T getClient(Class<T> interfaceClass, String domain, String umaAatClientId, String umaAatClientJksPath, String umaAatClientJksPassword, String umaAatClientKeyId) {
        UmaScimClient<T> handler = new UmaScimClient<T>(interfaceClass, domain, umaAatClientId, umaAatClientJksPath, umaAatClientJksPassword, umaAatClientKeyId);
        return ScimClientFactory.typedProxy(interfaceClass, handler);
    }

    public static ClientSideService getClient(String domain, String umaAatClientId, String umaAatClientJksPath, String umaAatClientJksPassword, String umaAatClientKeyId) {
        return ScimClientFactory.getClient(defaultInterface, domain, umaAatClientId, umaAatClientJksPath, umaAatClientJksPassword, umaAatClientKeyId);
    }

    public static <T> T getTestClient(Class<T> interfaceClass, String domain, String OIDCMetadataUrl) throws Exception {
        TestModeScimClient<T> handler = new TestModeScimClient<T>(interfaceClass, domain, OIDCMetadataUrl);
        return ScimClientFactory.typedProxy(interfaceClass, handler);
    }

    public static ClientSideService getTestClient(String domain, String OIDCMetadataUrl) throws Exception {
        return ScimClientFactory.getTestClient(defaultInterface, domain, OIDCMetadataUrl);
    }

    public static ClientSideService getDummyClient(String domain) throws Exception {
        DummyClient<ClientSideService> handler = new DummyClient<ClientSideService>(defaultInterface, domain);
        return ScimClientFactory.typedProxy(defaultInterface, handler);
    }

    private static <T> T typedProxy(Class<T> interfaceClass, InvocationHandler handler) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, handler));
    }

    static {
        SecurityProviderUtility.installBCProvider();
        defaultInterface = ClientSideService.class;
    }
}

