/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client;

import gluu.scim2.client.AbstractScimClient;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.Util;

public class TestModeScimClient<T>
extends AbstractScimClient<T> {
    private static final long serialVersionUID = 3141592672017122134L;
    private Logger logger = LogManager.getLogger(this.getClass());
    private String access_token;
    private String refresh_token;
    private String tokenEndpoint;
    private String registrationEndpoint;
    private static long clientExpiration = 0L;
    private static String clientId;
    private static String password;
    private static ObjectMapper mapper;
    private static final List<ResponseType> RESPONSE_TYPES;
    private static final String REDIRECT_URI = "http://localhost/";

    public TestModeScimClient(Class<T> serviceClass, String serviceUrl, String OIDCMetadataUrl) throws Exception {
        super(serviceUrl, serviceClass);
        JsonNode tree = mapper.readTree(new URL(OIDCMetadataUrl));
        this.registrationEndpoint = tree.get("registration_endpoint").asText();
        this.tokenEndpoint = tree.get("token_endpoint").asText();
        if (!Util.allNotBlank((String[])new String[]{this.registrationEndpoint, this.tokenEndpoint})) {
            throw new Exception("Couldn't extract endpoints from OIDC metadata URL: " + OIDCMetadataUrl);
        }
        this.triggerRegistrationIfNeeded();
        this.updateTokens(GrantType.CLIENT_CREDENTIALS);
    }

    private boolean triggerRegistrationIfNeeded() throws Exception {
        boolean flag = false;
        long now = new Date().getTime();
        if (clientExpiration < now) {
            RegisterRequest request = new RegisterRequest(ApplicationType.NATIVE, "SCIM-Client", new ArrayList());
            request.setResponseTypes(RESPONSE_TYPES);
            request.setRedirectUris(Arrays.asList(REDIRECT_URI));
            request.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
            request.setSubjectType(SubjectType.PAIRWISE);
            request.setGrantTypes(Arrays.asList(GrantType.CLIENT_CREDENTIALS));
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)request);
            RegisterResponse response = registerClient.exec();
            clientId = response.getClientId();
            password = response.getClientSecret();
            clientExpiration = response.getClientSecretExpiresAt().getTime();
            flag = true;
        }
        return flag;
    }

    private void updateTokens(GrantType grant) {
        this.access_token = null;
        this.access_token = this.getTokens(grant).getAccessToken();
        this.logger.debug("Got token: " + this.access_token);
    }

    private TokenResponse getTokens(GrantType grant) {
        TokenRequest tokenRequest = new TokenRequest(grant);
        tokenRequest.setAuthUsername(clientId);
        switch (grant) {
            case CLIENT_CREDENTIALS: {
                tokenRequest.setAuthPassword(password);
                break;
            }
            case REFRESH_TOKEN: {
                tokenRequest.setRefreshToken(this.refresh_token);
            }
        }
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        return tokenClient.exec();
    }

    @Override
    String getAuthenticationHeader() {
        return "Bearer " + this.access_token;
    }

    @Override
    boolean authorize(Response response) {
        try {
            this.triggerRegistrationIfNeeded();
            this.updateTokens(GrantType.CLIENT_CREDENTIALS);
            return this.access_token != null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static {
        mapper = new ObjectMapper();
        RESPONSE_TYPES = Arrays.asList(ResponseType.TOKEN);
    }
}

