/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.util;

import gluu.scim.client.ScimResponse;
import gluu.scim2.client.util.GroupDeserializer;
import gluu.scim2.client.util.ListResponseGroupDeserializer;
import gluu.scim2.client.util.ListResponseUserDeserializer;
import gluu.scim2.client.util.UserDeserializer;
import gluu.scim2.client.util.UserSerializer;
import java.io.IOException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;
import org.gluu.oxtrust.model.scim2.Group;
import org.gluu.oxtrust.model.scim2.ListResponse;
import org.gluu.oxtrust.model.scim2.User;
import org.gluu.oxtrust.model.scim2.schema.extension.UserExtensionSchema;

public class Util {
    public static Object jsonToObject(ScimResponse response, Class<?> clazz) throws Exception {
        byte[] bytes = response.getResponseBody();
        String json = new String(bytes);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }

    public static String getJSONStringUser(User user) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS});
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, ""));
        simpleModule.addSerializer(User.class, (JsonSerializer)new UserSerializer());
        mapper.registerModule((Module)simpleModule);
        String value = mapper.writeValueAsString((Object)user);
        return value;
    }

    public static User toUser(ScimResponse scimResponse, UserExtensionSchema userExtensionSchema) throws Exception {
        String response = Util.getResponseString(scimResponse);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        UserDeserializer userDeserializer = new UserDeserializer();
        userDeserializer.setUserExtensionSchema(userExtensionSchema);
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, ""));
        simpleModule.addDeserializer(User.class, (JsonDeserializer)userDeserializer);
        mapper.registerModule((Module)simpleModule);
        User user = (User)mapper.readValue(response, User.class);
        return user;
    }

    public static Group toGroup(ScimResponse scimResponse) throws Exception {
        String response = Util.getResponseString(scimResponse);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        GroupDeserializer groupDeserializer = new GroupDeserializer();
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, ""));
        simpleModule.addDeserializer(Group.class, (JsonDeserializer)groupDeserializer);
        mapper.registerModule((Module)simpleModule);
        Group group = (Group)mapper.readValue(response, Group.class);
        return group;
    }

    public static ListResponse toListResponseUser(ScimResponse scimResponse, UserExtensionSchema userExtensionSchema) throws Exception {
        String response = Util.getResponseString(scimResponse);
        ListResponse listResponse = Util.jsonToListResponseUser(response, userExtensionSchema);
        return listResponse;
    }

    public static ListResponse toListResponseGroup(ScimResponse scimResponse) throws Exception {
        byte[] bytes = scimResponse.getResponseBody();
        String response = new String(bytes);
        ListResponse listResponse = Util.jsonToListResponseGroup(response);
        return listResponse;
    }

    private static ListResponse jsonToListResponseUser(String json, UserExtensionSchema userExtensionSchema) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        ListResponseUserDeserializer listResponseUserDeserializer = new ListResponseUserDeserializer();
        listResponseUserDeserializer.setUserExtensionSchema(userExtensionSchema);
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, ""));
        simpleModule.addDeserializer(ListResponse.class, (JsonDeserializer)listResponseUserDeserializer);
        mapper.registerModule((Module)simpleModule);
        ListResponse listResponseUser = (ListResponse)mapper.readValue(json, ListResponse.class);
        return listResponseUser;
    }

    private static ListResponse jsonToListResponseGroup(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        ListResponseGroupDeserializer listResponseGroupDeserializer = new ListResponseGroupDeserializer();
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, ""));
        simpleModule.addDeserializer(ListResponse.class, (JsonDeserializer)listResponseGroupDeserializer);
        mapper.registerModule((Module)simpleModule);
        ListResponse listResponseGroup = (ListResponse)mapper.readValue(json, ListResponse.class);
        return listResponseGroup;
    }

    private static String getResponseString(ScimResponse scimResponse) {
        byte[] bytes = scimResponse.getResponseBody();
        String response = new String(bytes);
        return response;
    }
}

