/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.gluu.oxtrust.model.scim2.Extension;
import org.gluu.oxtrust.model.scim2.ExtensionFieldType;
import org.gluu.oxtrust.model.scim2.User;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class UserSerializer
extends JsonSerializer<User> {
    public void serialize(User user, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        System.out.println(" IN UserSerializer.serialize()... ");
        try {
            jsonGenerator.writeStartObject();
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS});
            JsonNode rootNode = (JsonNode)mapper.convertValue((Object)user, JsonNode.class);
            Iterator iterator = rootNode.getFields();
            while (iterator.hasNext()) {
                Map.Entry rootNodeEntry = (Map.Entry)iterator.next();
                jsonGenerator.writeFieldName((String)rootNodeEntry.getKey());
                if (((String)rootNodeEntry.getKey()).equals("urn:ietf:params:scim:schemas:extension:gluu:2.0:User")) {
                    Extension extension = user.getExtension((String)rootNodeEntry.getKey());
                    HashMap list = new HashMap();
                    for (Map.Entry extEntry : extension.getFields().entrySet()) {
                        if (((Extension.Field)extEntry.getValue()).isMultiValued()) {
                            if (((Extension.Field)extEntry.getValue()).getType().equals(ExtensionFieldType.STRING)) {
                                List<Object> stringList = Arrays.asList((Object[])mapper.readValue(((Extension.Field)extEntry.getValue()).getValue(), String[].class));
                                list.put(extEntry.getKey(), stringList);
                                continue;
                            }
                            if (((Extension.Field)extEntry.getValue()).getType().equals(ExtensionFieldType.DATE_TIME)) {
                                List<Object> dateList = Arrays.asList((Object[])mapper.readValue(((Extension.Field)extEntry.getValue()).getValue(), Date[].class));
                                ArrayList<String> stringList = new ArrayList<String>();
                                DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();
                                for (Date date : dateList) {
                                    String dateString = dateTimeFormatter.print(date.getTime());
                                    stringList.add(dateString);
                                }
                                list.put(extEntry.getKey(), stringList);
                                continue;
                            }
                            if (!((Extension.Field)extEntry.getValue()).getType().equals(ExtensionFieldType.DECIMAL)) continue;
                            List<Object> numberList = Arrays.asList((Object[])mapper.readValue(((Extension.Field)extEntry.getValue()).getValue(), BigDecimal[].class));
                            list.put(extEntry.getKey(), numberList);
                            continue;
                        }
                        list.put(extEntry.getKey(), ((Extension.Field)extEntry.getValue()).getValue());
                    }
                    jsonGenerator.writeObject(list);
                    continue;
                }
                jsonGenerator.writeObject(rootNodeEntry.getValue());
            }
            jsonGenerator.writeEndObject();
            System.out.println(" LEAVING UserSerializer.serialize()... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unexpected processing error; please check the input parameters.");
        }
    }
}

