/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.util;

import gluu.scim2.client.util.ExtensionDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.gluu.oxtrust.model.scim2.Extension;
import org.gluu.oxtrust.model.scim2.GroupRef;
import org.gluu.oxtrust.model.scim2.User;
import org.gluu.oxtrust.model.scim2.schema.extension.UserExtensionSchema;

public class UserDeserializer
extends JsonDeserializer<User> {
    private UserExtensionSchema userExtensionSchema;

    public User deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        System.out.println(" IN UserDeserializer.deserialize()... ");
        try {
            JsonNode rootNode = jsonParser.readValueAsTree();
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            User user = (User)mapper.readValue(rootNode.toString(), User.class);
            if (user.getSchemas() == null) {
                throw new IllegalArgumentException("Required field \"schemas\" is null or missing.");
            }
            if (!user.getSchemas().contains("urn:ietf:params:scim:schemas:core:2.0:User")) {
                throw new IllegalArgumentException("User Core schema is required.");
            }
            if (user.getSchemas().contains("urn:ietf:params:scim:schemas:extension:gluu:2.0:User")) {
                JsonNode userExtensionNode = rootNode.get("urn:ietf:params:scim:schemas:extension:gluu:2.0:User");
                if (userExtensionNode != null) {
                    ExtensionDeserializer deserializer = new ExtensionDeserializer();
                    deserializer.setId("urn:ietf:params:scim:schemas:extension:gluu:2.0:User");
                    deserializer.setUserExtensionSchema(this.userExtensionSchema);
                    SimpleModule extensionDeserializerModule = new SimpleModule("ExtensionDeserializerModule", new Version(1, 0, 0, ""));
                    extensionDeserializerModule.addDeserializer(Extension.class, (JsonDeserializer)deserializer);
                    mapper.registerModule((Module)extensionDeserializerModule);
                    Extension extension = (Extension)mapper.readValue(userExtensionNode.toString(), Extension.class);
                    user.addExtension(extension);
                } else {
                    throw new IllegalArgumentException("User Extension schema is indicated, but value body is absent.");
                }
            }
            ArrayList<GroupRef> groups = new ArrayList<GroupRef>();
            JsonNode groupsNode = rootNode.get("groups");
            if (groupsNode != null && !(groupsNode instanceof NullNode)) {
                ArrayNode arrayGroupsNode = (ArrayNode)groupsNode;
                for (int i = 0; i < arrayGroupsNode.size(); ++i) {
                    JsonNode arrayNode = arrayGroupsNode.get(i);
                    Iterator iterator = arrayNode.getFields();
                    GroupRef group = new GroupRef();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (entry.getValue() instanceof NullNode || ((JsonNode)entry.getValue()).asText().isEmpty()) continue;
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("value")) {
                            group.setValue(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("display")) {
                            group.setDisplay(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("type")) {
                            if (GroupRef.Type.DIRECT.getValue().equalsIgnoreCase(((JsonNode)entry.getValue()).asText())) {
                                group.setType(GroupRef.Type.DIRECT);
                                continue;
                            }
                            if (!GroupRef.Type.INDIRECT.getValue().equalsIgnoreCase(((JsonNode)entry.getValue()).asText())) continue;
                            group.setType(GroupRef.Type.INDIRECT);
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("$ref")) {
                            group.setReference(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() == null || !((String)entry.getKey()).equalsIgnoreCase("operation")) continue;
                        group.setOperation(((JsonNode)entry.getValue()).asText());
                    }
                    groups.add(group);
                }
            }
            user.setGroups(groups);
            System.out.println(" LEAVING UserDeserializer.deserialize()... ");
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unexpected processing error: " + e.getMessage());
        }
    }

    public void setUserExtensionSchema(UserExtensionSchema userExtensionSchema) {
        this.userExtensionSchema = userExtensionSchema;
    }
}

