/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.gluu.oxtrust.model.scim2.Group;
import org.gluu.oxtrust.model.scim2.MemberRef;

public class GroupDeserializer
extends JsonDeserializer<Group> {
    public Group deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        System.out.println(" IN GroupDeserializer.deserialize()... ");
        try {
            JsonNode rootNode = jsonParser.readValueAsTree();
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            Group group = (Group)mapper.readValue(rootNode.toString(), Group.class);
            HashSet<MemberRef> members = new HashSet<MemberRef>();
            JsonNode membersNode = rootNode.get("members");
            if (membersNode != null && !(membersNode instanceof NullNode)) {
                ArrayNode arrayMembersNode = (ArrayNode)membersNode;
                for (int i = 0; i < arrayMembersNode.size(); ++i) {
                    JsonNode arrayNode = arrayMembersNode.get(i);
                    Iterator iterator = arrayNode.getFields();
                    MemberRef member = new MemberRef();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (entry.getValue() instanceof NullNode || ((JsonNode)entry.getValue()).asText().isEmpty()) continue;
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("value")) {
                            member.setValue(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("display")) {
                            member.setDisplay(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("type")) {
                            if (MemberRef.Type.USER.getValue().equalsIgnoreCase(((JsonNode)entry.getValue()).asText())) {
                                member.setType(MemberRef.Type.USER);
                                continue;
                            }
                            if (!MemberRef.Type.GROUP.getValue().equalsIgnoreCase(((JsonNode)entry.getValue()).asText())) continue;
                            member.setType(MemberRef.Type.GROUP);
                            continue;
                        }
                        if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("$ref")) {
                            member.setReference(((JsonNode)entry.getValue()).asText());
                            continue;
                        }
                        if (entry.getKey() == null || !((String)entry.getKey()).equalsIgnoreCase("operation")) continue;
                        member.setOperation(((JsonNode)entry.getValue()).asText());
                    }
                    members.add(member);
                }
            }
            group.setMembers(members);
            System.out.println(" LEAVING GroupDeserializer.deserialize()... ");
            return group;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unexpected processing error: " + e.getMessage());
        }
    }
}

