/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.gluu.oxtrust.model.scim2.Extension;
import org.gluu.oxtrust.model.scim2.ExtensionFieldType;
import org.gluu.oxtrust.model.scim2.schema.AttributeHolder;
import org.gluu.oxtrust.model.scim2.schema.extension.UserExtensionSchema;

public class ExtensionDeserializer
extends JsonDeserializer<Extension> {
    private String id;
    private UserExtensionSchema userExtensionSchema;

    public Extension deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        System.out.println(" IN ExtensionDeserializer.deserialize()... ");
        try {
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalArgumentException("The URN cannot be null or empty");
            }
            JsonNode rootNode = jsonParser.readValueAsTree();
            if (!rootNode.isObject()) {
                throw new IllegalArgumentException("Extension is of wrong JSON type");
            }
            Extension.Builder extensionBuilder = new Extension.Builder(this.id);
            Iterator fieldIterator = rootNode.getFields();
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            block2: while (fieldIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)fieldIterator.next();
                if (entry.getValue() == null || entry.getValue() instanceof NullNode) continue;
                for (AttributeHolder attributeHolder : this.userExtensionSchema.getAttributes()) {
                    if (!((String)entry.getKey()).equals(attributeHolder.getName())) continue;
                    if (attributeHolder.getMultiValued().equals(Boolean.TRUE)) {
                        ArrayNode arrayNode = (ArrayNode)entry.getValue();
                        if (attributeHolder.getType().equals("string") || attributeHolder.getType().equals("reference")) {
                            List<Object> stringList = Arrays.asList((Object[])mapper.readValue((JsonNode)arrayNode, String[].class));
                            extensionBuilder.setFieldAsList((String)entry.getKey(), stringList);
                            continue block2;
                        }
                        if (attributeHolder.getType().equals("dateTime")) {
                            List<Object> dateList = Arrays.asList((Object[])mapper.readValue((JsonNode)arrayNode, Date[].class));
                            extensionBuilder.setFieldAsList((String)entry.getKey(), Arrays.asList((Object[])mapper.readValue((JsonNode)arrayNode, String[].class)));
                            continue block2;
                        }
                        if (!attributeHolder.getType().equals("decimal")) continue block2;
                        List<Object> numberList = Arrays.asList((Object[])mapper.readValue((JsonNode)arrayNode, BigDecimal[].class));
                        extensionBuilder.setFieldAsList((String)entry.getKey(), numberList);
                        continue block2;
                    }
                    if (attributeHolder.getType().equals("string") || attributeHolder.getType().equals("reference")) {
                        this.handleString(extensionBuilder, entry);
                        continue block2;
                    }
                    if (attributeHolder.getType().equals("dateTime")) {
                        this.handleDateTime(extensionBuilder, entry);
                        continue block2;
                    }
                    if (!attributeHolder.getType().equals("decimal")) continue block2;
                    this.handleNumber(extensionBuilder, entry);
                    continue block2;
                }
            }
            System.out.println(" LEAVING ExtensionDeserializer.deserialize()... ");
            return extensionBuilder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unexpected processing error: " + e.getMessage());
        }
    }

    private void handleNumber(Extension.Builder extensionBuilder, Map.Entry<String, JsonNode> entry) {
        BigDecimal value = (BigDecimal)ExtensionFieldType.DECIMAL.fromString(entry.getValue().asText());
        extensionBuilder.setField(entry.getKey(), value);
    }

    private void handleString(Extension.Builder extensionBuilder, Map.Entry<String, JsonNode> entry) {
        String value = (String)ExtensionFieldType.STRING.fromString(entry.getValue().asText());
        extensionBuilder.setField(entry.getKey(), value);
    }

    private void handleDateTime(Extension.Builder extensionBuilder, Map.Entry<String, JsonNode> entry) {
        Date value = (Date)ExtensionFieldType.DATE_TIME.fromString(entry.getValue().asText());
        extensionBuilder.setField(entry.getKey(), value);
    }

    void setId(String id) {
        this.id = id;
    }

    public void setUserExtensionSchema(UserExtensionSchema userExtensionSchema) {
        this.userExtensionSchema = userExtensionSchema;
    }
}

