/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client.auth;

import gluu.scim.client.ScimResponse;
import gluu.scim.client.exception.ScimInitializationException;
import gluu.scim2.client.BaseScim2ClientImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.oxtrust.model.scim2.Group;
import org.gluu.oxtrust.model.scim2.User;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.uma.CreateRptService;
import org.xdi.oxauth.client.uma.RptAuthorizationRequestService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.crypto.PrivateKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.uma.PermissionTicket;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptAuthorizationResponse;
import org.xdi.oxauth.model.uma.UmaConfiguration;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.JwksUtil;
import org.xdi.util.StringHelper;

public class UmaScim2ClientImpl
extends BaseScim2ClientImpl {
    private static final long serialVersionUID = 7099883500099353832L;
    private UmaConfiguration metadataConfiguration;
    private Token umaAat;
    private RPTResponse umaRpt;
    private String umaMetaDataUrl;
    private String umaAatClientId;
    private String umaAatClientKeyId;
    private String umaAatClientJwks;
    protected ClientExecutor executor;
    private long umaAatAccessTokenExpiration = 0L;
    private final ReentrantLock lock = new ReentrantLock();

    public UmaScim2ClientImpl(String domain, String umaMetaDataUrl, String umaAatClientId, String umaAatClientJwks, String umaAatClientKeyId) {
        super(domain);
        this.umaMetaDataUrl = umaMetaDataUrl;
        this.umaAatClientId = umaAatClientId;
        this.umaAatClientJwks = umaAatClientJwks;
        this.umaAatClientKeyId = umaAatClientKeyId;
    }

    @Override
    protected void init() {
        this.initUmaAuthentication();
    }

    @Override
    protected void addAuthenticationHeader(HttpMethodBase httpMethod) {
        httpMethod.setRequestHeader("Authorization", "Bearer " + this.umaRpt.getRpt());
    }

    private void initUmaAuthentication() {
        long now = System.currentTimeMillis();
        if (!this.isValidToken(now)) {
            this.lock.lock();
            try {
                now = System.currentTimeMillis();
                if (!this.isValidToken(now)) {
                    this.initUmaRpt();
                    this.umaAatAccessTokenExpiration = this.computeAccessTokenExpirationTime(this.umaAat.getExpiresIn());
                }
            }
            catch (Exception ex) {
                throw new ScimInitializationException("Could not get accessToken", ex);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isValidToken(long now) {
        return this.umaAat != null && this.umaAat.getAccessToken() != null && this.umaAatAccessTokenExpiration > now;
    }

    private void initUmaRpt() {
        this.umaAat = null;
        this.umaRpt = null;
        this.metadataConfiguration = this.executor == null ? UmaClientFactory.instance().createMetaDataConfigurationService(this.umaMetaDataUrl).getMetadataConfiguration() : UmaClientFactory.instance().createMetaDataConfigurationService(this.umaMetaDataUrl, this.executor).getMetadataConfiguration();
        if (this.metadataConfiguration == null || !StringHelper.equals((String)this.metadataConfiguration.getVersion(), (String)"1.0")) {
            throw new ScimInitializationException("Failed to load valid UMA metadata configuration");
        }
        PrivateKey privateKey = null;
        try {
            privateKey = JwksUtil.getPrivateKey(null, (String)this.umaAatClientJwks, (String)this.umaAatClientKeyId);
            if (privateKey == null) {
                throw new ScimInitializationException("There is no keyId in JWKS");
            }
            TokenRequest tokenRequest = TokenRequest.builder().aat(new String[0]).grantType(GrantType.CLIENT_CREDENTIALS).build();
            if (privateKey instanceof ECDSAPrivateKey) {
                tokenRequest.setEcPrivateKey((ECDSAPrivateKey)privateKey);
            } else if (privateKey instanceof RSAPrivateKey) {
                tokenRequest.setRsaPrivateKey((RSAPrivateKey)privateKey);
            }
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
            tokenRequest.setAuthUsername(this.umaAatClientId);
            tokenRequest.setAlgorithm(privateKey.getSignatureAlgorithm());
            tokenRequest.setKeyId(privateKey.getKeyId());
            tokenRequest.setAudience(this.metadataConfiguration.getTokenEndpoint());
            this.umaAat = UmaClient.request((String)this.metadataConfiguration.getTokenEndpoint(), (TokenRequest)tokenRequest);
        }
        catch (ClientResponseFailure ex) {
            String errorMessage = (String)ex.getResponse().getEntity(String.class);
            throw new ScimInitializationException("Failed to get AAT token. Error: " + errorMessage, ex);
        }
        catch (Exception ex) {
            throw new ScimInitializationException("Failed to get AAT token", ex);
        }
        if (this.umaAat == null) {
            throw new ScimInitializationException("Failed to get UMA AAT token");
        }
        CreateRptService rptService = null;
        rptService = this.executor == null ? UmaClientFactory.instance().createRequesterPermissionTokenService(this.metadataConfiguration) : UmaClientFactory.instance().createRequesterPermissionTokenService(this.metadataConfiguration, this.executor);
        this.umaRpt = null;
        try {
            this.umaRpt = rptService.createRPT("Bearer " + this.umaAat.getAccessToken(), this.getHost(this.metadataConfiguration.getIssuer()));
        }
        catch (ClientResponseFailure ex) {
            String errorMessage = (String)ex.getResponse().getEntity(String.class);
            throw new ScimInitializationException("Failed to get RPT token. Error: " + errorMessage, ex);
        }
        catch (MalformedURLException ex) {
            throw new ScimInitializationException("Failed to determine host by URI", ex);
        }
        if (this.umaRpt == null) {
            throw new ScimInitializationException("Failed to get UMA RPT token");
        }
    }

    private boolean autorizeRpt(ScimResponse scimResponse) {
        if (scimResponse.getStatusCode() == 403) {
            PermissionTicket resourceSetPermissionTicket;
            try {
                resourceSetPermissionTicket = (PermissionTicket)new ObjectMapper().readValue(scimResponse.getResponseBody(), PermissionTicket.class);
            }
            catch (Exception ex) {
                throw new ScimInitializationException("UMA ticket is invalid", ex);
            }
            this.authorizeRpt(resourceSetPermissionTicket.getTicket());
            if (StringHelper.isEmpty((String)resourceSetPermissionTicket.getTicket())) {
                throw new ScimInitializationException("UMA ticket is invalid");
            }
            return true;
        }
        return false;
    }

    private boolean authorizeRpt(String ticket) {
        try {
            RptAuthorizationRequestService authorizationRequestService = null;
            RptAuthorizationRequest rptAuthorizationRequest = new RptAuthorizationRequest(this.umaRpt.getRpt(), ticket);
            authorizationRequestService = this.executor == null ? UmaClientFactory.instance().createAuthorizationRequestService(this.metadataConfiguration) : UmaClientFactory.instance().createAuthorizationRequestService(this.metadataConfiguration, this.executor);
            RptAuthorizationResponse rptAuthorizationResponse = authorizationRequestService.requestRptPermissionAuthorization("Bearer " + this.umaAat.getAccessToken(), this.getHost(this.metadataConfiguration.getIssuer()), rptAuthorizationRequest);
            if (rptAuthorizationResponse == null) {
                throw new ScimInitializationException("UMA ticket authorization response is invalid");
            }
            return true;
        }
        catch (ClientResponseFailure ex) {
            String errorMessage = (String)ex.getResponse().getEntity(String.class);
            throw new ScimInitializationException("Failed to authorize UMA ticket. Error: " + errorMessage, ex);
        }
        catch (MalformedURLException ex) {
            throw new ScimInitializationException("Failed to determine host by URI", ex);
        }
        catch (Exception ex) {
            throw new ScimInitializationException(ex.getMessage(), ex);
        }
    }

    @Override
    @Deprecated
    public ScimResponse retrievePerson(String id, String mediaType) throws IOException {
        return this.retrieveUser(id, new String[0]);
    }

    @Override
    public ScimResponse retrieveUser(String id, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.retrieveUser(id, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.retrieveUser(id, attributesArray);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse createPerson(User user, String mediaType) throws IOException, JAXBException {
        return this.createUser(user, new String[0]);
    }

    @Override
    public ScimResponse createUser(User user, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.createUser(user, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.createUser(user, attributesArray);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse updatePerson(User user, String id, String mediaType) throws IOException, JAXBException {
        return this.updateUser(user, id, new String[0]);
    }

    @Override
    public ScimResponse updateUser(User user, String id, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.updateUser(user, id, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.updateUser(user, id, attributesArray);
        }
        return scimResponse;
    }

    @Override
    public ScimResponse deletePerson(String uid) throws IOException {
        ScimResponse scimResponse = super.deletePerson(uid);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.deletePerson(uid);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse retrieveGroup(String id, String mediaType) throws IOException {
        return this.retrieveGroup(id, new String[0]);
    }

    @Override
    public ScimResponse retrieveGroup(String id, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.retrieveGroup(id, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.retrieveGroup(id, attributesArray);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse createGroup(Group group, String mediaType) throws IOException, JAXBException {
        return this.createGroup(group, new String[0]);
    }

    @Override
    public ScimResponse createGroup(Group group, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.createGroup(group, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.createGroup(group, attributesArray);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse updateGroup(Group group, String id, String mediaType) throws IOException, JAXBException {
        return this.updateGroup(group, id, new String[0]);
    }

    @Override
    public ScimResponse updateGroup(Group group, String id, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.updateGroup(group, id, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.updateGroup(group, id, attributesArray);
        }
        return scimResponse;
    }

    @Override
    public ScimResponse deleteGroup(String id) throws IOException {
        ScimResponse scimResponse = super.deleteGroup(id);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.deleteGroup(id);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse createPersonString(String person, String mediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.createPersonString(person, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.createPersonString(person, mediaType);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse updatePersonString(String person, String id, String mediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.updatePersonString(person, id, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.updatePersonString(person, id, mediaType);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse createGroupString(String group, String mediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.createGroupString(group, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.createGroupString(group, mediaType);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse updateGroupString(String group, String id, String mediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.updateGroupString(group, id, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.updateGroupString(group, id, mediaType);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse bulkOperationString(String operation, String mediaType) throws IOException {
        ScimResponse scimResponse = super.bulkOperationString(operation, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.bulkOperationString(operation, mediaType);
        }
        return scimResponse;
    }

    @Override
    public ScimResponse retrieveAllUsers() throws IOException {
        ScimResponse scimResponse = super.retrieveAllUsers();
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.retrieveAllUsers();
        }
        return scimResponse;
    }

    @Override
    public ScimResponse searchUsers(String filter, int startIndex, int count, String sortBy, String sortOrder, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.searchUsers(filter, startIndex, count, sortBy, sortOrder, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.searchUsers(filter, startIndex, count, sortBy, sortOrder, attributesArray);
        }
        return scimResponse;
    }

    @Override
    public ScimResponse retrieveAllGroups() throws IOException {
        ScimResponse scimResponse = super.retrieveAllGroups();
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.retrieveAllGroups();
        }
        return scimResponse;
    }

    @Override
    public ScimResponse searchGroups(String filter, int startIndex, int count, String sortBy, String sortOrder, String[] attributesArray) throws IOException {
        ScimResponse scimResponse = super.searchGroups(filter, startIndex, count, sortBy, sortOrder, attributesArray);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.searchGroups(filter, startIndex, count, sortBy, sortOrder, attributesArray);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse personSearch(String attribute, String value, String mediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.personSearch(attribute, value, mediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.personSearch(attribute, value, mediaType);
        }
        return scimResponse;
    }

    @Override
    @Deprecated
    public ScimResponse personSearchByObject(String attribute, Object value, String valueMediaType, String outPutMediaType) throws IOException, JAXBException {
        ScimResponse scimResponse = super.personSearchByObject(attribute, value, valueMediaType, outPutMediaType);
        if (this.autorizeRpt(scimResponse)) {
            scimResponse = super.personSearchByObject(attribute, value, valueMediaType, outPutMediaType);
        }
        return scimResponse;
    }

    public ClientExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ClientExecutor executor) {
        this.executor = executor;
    }
}

