/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim2.client;

import gluu.scim.client.ScimResponse;
import gluu.scim.client.model.ScimPersonSearch;
import gluu.scim.client.util.ResponseMapper;
import gluu.scim2.client.BaseScim2Client;
import gluu.scim2.client.util.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.model.scim2.BulkRequest;
import org.gluu.oxtrust.model.scim2.Group;
import org.gluu.oxtrust.model.scim2.User;
import org.gluu.oxtrust.model.scim2.schema.extension.UserExtensionSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScim2ClientImpl
implements BaseScim2Client {
    private static final long serialVersionUID = 9098930517944520482L;
    private static final Logger log = LoggerFactory.getLogger(BaseScim2ClientImpl.class);
    private String domain;

    public BaseScim2ClientImpl(String domain) {
        this.domain = domain;
    }

    protected String getHost(String uri) throws MalformedURLException {
        URL url = new URL(uri);
        return url.getHost();
    }

    protected long computeAccessTokenExpirationTime(Integer expiresIn) {
        Calendar calendar = Calendar.getInstance();
        if (expiresIn != null) {
            calendar.add(13, expiresIn);
            calendar.add(13, -10);
        }
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveServiceProviderConfig() throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/ServiceProviderConfig");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveResourceTypes() throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/ResourceTypes");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse retrievePerson(String id, String mediaType) throws IOException {
        return this.retrieveUser(id, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveUser(String id, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/Users/" + id);
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        get.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse createPerson(User user, String mediaType) throws IOException, JAXBException {
        return this.createUser(user, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createUser(User user, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Users");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONStringUser(user), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse updatePerson(User user, String id, String mediaType) throws IOException, JAXBException {
        return this.updateUser(user, id, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updateUser(User user, String id, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v2/Users/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        put.setRequestHeader("Accept", "application/scim+json");
        put.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        put.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONStringUser(user), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse deletePerson(String id) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        DeleteMethod delete = new DeleteMethod(this.domain + "/scim/v2/Users/" + id);
        delete.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)delete);
        delete.setRequestHeader("Accept", "application/scim+json");
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)delete);
            ScimResponse scimResponse = response = ResponseMapper.map(delete, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            delete.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse retrieveGroup(String id, String mediaType) throws IOException {
        return this.retrieveGroup(id, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveGroup(String id, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/Groups/" + id);
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        get.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse createGroup(Group group, String mediaType) throws IOException, JAXBException {
        return this.createGroup(group, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createGroup(Group group, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Groups");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        post.setRequestEntity((RequestEntity)new StringRequestEntity(gluu.scim.client.util.Util.getJSONString(group), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScimResponse updateGroup(Group group, String id, String mediaType) throws IOException, JAXBException {
        return this.updateGroup(group, id, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updateGroup(Group group, String id, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v2/Groups/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        put.setRequestHeader("Accept", "application/scim+json");
        put.setQueryString(new NameValuePair[]{new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        put.setRequestEntity((RequestEntity)new StringRequestEntity(gluu.scim.client.util.Util.getJSONString(group), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse deleteGroup(String id) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        DeleteMethod delete = new DeleteMethod(this.domain + "/scim/v2/Groups/" + id);
        delete.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)delete);
        delete.setRequestHeader("Accept", "application/scim+json");
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)delete);
            ScimResponse scimResponse = response = ResponseMapper.map(delete, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            delete.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse createPersonString(String person, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Users/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(person, "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse updatePersonString(String person, String id, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v2/Users/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        put.setRequestHeader("Accept", "application/scim+json");
        put.setRequestEntity((RequestEntity)new StringRequestEntity(person, "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse createGroupString(String group, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Groups/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(group, "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse updateGroupString(String group, String id, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v2/Groups/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        put.setRequestHeader("Accept", "application/scim+json");
        put.setRequestEntity((RequestEntity)new StringRequestEntity(group, "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse bulkOperation(BulkRequest bulkRequest, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Bulk/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(gluu.scim.client.util.Util.getJSONString(bulkRequest), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse bulkOperationString(String operation, String mediaType) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Bulk/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(operation, "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        throw null;
    }

    @Override
    public ScimResponse retrieveAllUsers() throws IOException {
        return this.searchUsers("", 1, 200, "", "", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse searchUsers(String filter, int startIndex, int count, String sortBy, String sortOrder, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/Users/");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        get.setQueryString(new NameValuePair[]{new NameValuePair("filter", filter), new NameValuePair("startIndex", String.valueOf(startIndex)), new NameValuePair("count", String.valueOf(count)), new NameValuePair("sortBy", sortBy), new NameValuePair("sortOrder", sortOrder), new NameValuePair("attributes", attributesArray != null ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    @Override
    public ScimResponse retrieveAllGroups() throws IOException {
        return this.searchGroups("", 1, 200, "", "", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse searchGroups(String filter, int startIndex, int count, String sortBy, String sortOrder, String[] attributesArray) throws IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v2/Groups/");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        get.setRequestHeader("Accept", "application/scim+json");
        get.setQueryString(new NameValuePair[]{new NameValuePair("filter", filter), new NameValuePair("startIndex", String.valueOf(startIndex)), new NameValuePair("count", String.valueOf(count)), new NameValuePair("sortBy", sortBy), new NameValuePair("sortOrder", sortOrder), new NameValuePair("attributes", attributesArray != null && attributesArray.length > 0 ? StringUtils.join((Object[])attributesArray, (char)',') : null)});
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse personSearch(String attribute, String value, String mediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Users/Search");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        ScimPersonSearch searchPattern = new ScimPersonSearch();
        searchPattern.setAttribute(attribute);
        searchPattern.setValue(value);
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(gluu.scim.client.util.Util.getJSONString(searchPattern), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ScimResponse personSearchByObject(String attribute, Object value, String valueMediaType, String outPutMediaType) throws IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v2/Users/Search");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        ScimPersonSearch searchPattern = new ScimPersonSearch();
        searchPattern.setAttribute(attribute);
        String stringValue = gluu.scim.client.util.Util.getJSONString(value);
        searchPattern.setValue(stringValue);
        this.addAuthenticationHeader((HttpMethodBase)post);
        post.setRequestHeader("Accept", "application/scim+json");
        post.setRequestEntity((RequestEntity)new StringRequestEntity(gluu.scim.client.util.Util.getJSONString(searchPattern), "application/scim+json", "utf-8"));
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, new ScimResponse());
            return scimResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    @Override
    public UserExtensionSchema getUserExtensionSchema() throws Exception {
        GetMethod get = new GetMethod(this.domain + "/scim/v2/Schemas/" + "urn:ietf:params:scim:schemas:extension:gluu:2.0:User");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        get.setRequestHeader("Accept", "application/scim+json");
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod((HttpMethod)get);
        ScimResponse response = ResponseMapper.map(get, new ScimResponse());
        UserExtensionSchema userExtensionSchema = (UserExtensionSchema)Util.jsonToObject(response, UserExtensionSchema.class);
        return userExtensionSchema;
    }

    protected abstract void init();

    protected abstract void addAuthenticationHeader(HttpMethodBase var1);
}

