/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim.client.util;

import gluu.scim.client.model.ScimBulkOperation;
import gluu.scim.client.model.ScimBulkResponse;
import gluu.scim.client.model.ScimGroup;
import gluu.scim.client.model.ScimPerson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class Converter
implements Serializable {
    private static final long serialVersionUID = 2673025645297827236L;

    public static String xmlToJsonPerson(String xml) throws Exception {
        ScimPerson person = (ScimPerson)Converter.xmlToObject(xml, ScimPerson.class);
        String response = Converter.getJSONString(person);
        return response;
    }

    public static String jsonToXMLPerson(String json) throws Exception {
        ScimPerson person = (ScimPerson)Converter.jsonToObject(json, ScimPerson.class);
        String response = Converter.getXMLString(person, ScimPerson.class);
        return response;
    }

    public static String xmlToJsonGroup(String xml) throws Exception {
        ScimGroup group = (ScimGroup)Converter.xmlToObject(xml, ScimGroup.class);
        String response = Converter.getJSONString(group);
        return response;
    }

    public static String jsonToXMLGroup(String json) throws Exception {
        ScimGroup group = (ScimGroup)Converter.jsonToObject(json, ScimGroup.class);
        String response = Converter.getXMLString(group, ScimGroup.class);
        return response;
    }

    public static String xmlToJsonBulkOperation(String xml) throws Exception {
        ScimBulkOperation operation = (ScimBulkOperation)Converter.xmlToObject(xml, ScimBulkOperation.class);
        String response = Converter.getJSONString(operation);
        return response;
    }

    public static String jsonToXMLBulkOperation(String json) throws Exception {
        ScimBulkOperation operation = (ScimBulkOperation)Converter.jsonToObject(json, ScimBulkOperation.class);
        String response = Converter.getXMLString(operation, ScimBulkOperation.class);
        return response;
    }

    public static String xmlToJsonScimBulkResponse(String xml) throws Exception {
        ScimBulkResponse operation = (ScimBulkResponse)Converter.xmlToObject(xml, ScimBulkResponse.class);
        String response = Converter.getJSONString(operation);
        return response;
    }

    public static String jsonToXMLScimBulkResponse(String json) throws Exception {
        ScimBulkResponse operation = (ScimBulkResponse)Converter.jsonToObject(json, ScimBulkResponse.class);
        String response = Converter.getXMLString(operation, ScimBulkResponse.class);
        return response;
    }

    public static ScimPerson xmlToScimPerson(String xml) throws Exception {
        ScimPerson person = (ScimPerson)Converter.xmlToObject(xml, ScimPerson.class);
        return person;
    }

    public static ScimPerson jsonToScimPerson(String json) throws Exception {
        ScimPerson person = (ScimPerson)Converter.jsonToObject(json, ScimPerson.class);
        return person;
    }

    public static ScimGroup xmlToScimGroup(String xml) throws Exception {
        ScimGroup group = (ScimGroup)Converter.xmlToObject(xml, ScimGroup.class);
        return group;
    }

    public static ScimGroup jsonToScimGroup(String json) throws Exception {
        ScimGroup group = (ScimGroup)Converter.jsonToObject(json, ScimGroup.class);
        return group;
    }

    public static ScimBulkResponse xmlToScimBulkResponse(String xml) throws Exception {
        ScimBulkResponse operation = (ScimBulkResponse)Converter.xmlToObject(xml, ScimBulkResponse.class);
        return operation;
    }

    public static ScimBulkResponse jsonToScimBulkResponse(String json) throws Exception {
        ScimBulkResponse operation = (ScimBulkResponse)Converter.jsonToObject(json, ScimBulkResponse.class);
        return operation;
    }

    private static Object xmlToObject(String xml, Class<?> clazz) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        Object clazzObject = jaxbUnmarshaller.unmarshal((InputStream)input);
        return clazzObject;
    }

    private static String getJSONString(Object entity) throws IOException {
        StringWriter sw = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)sw, entity);
        return sw.toString();
    }

    private static Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }

    private static String getXMLString(Object entity, Class<?> clazz) throws JAXBException {
        StringWriter sw = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        context.createMarshaller().marshal(entity, (Writer)sw);
        return sw.toString();
    }
}

