/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim.client;

import gluu.scim.client.BaseScimClient;
import gluu.scim.client.ScimResponse;
import gluu.scim.client.auth.UmaScimClientImpl;
import gluu.scim.client.model.ScimBulkOperation;
import gluu.scim.client.model.ScimGroup;
import gluu.scim.client.model.ScimPerson;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.xdi.oxauth.model.util.SecurityProviderUtility;

public class ScimClient
implements BaseScimClient,
Serializable {
    private static final long serialVersionUID = 5919055665311654721L;
    private BaseScimClient scimClient;

    public static ScimClient umaInstance(String domain, String umaMetaDataUrl, String umaAatClientId, String umaAatClientJwks, String umaAatClientKeyId) {
        SecurityProviderUtility.installBCProvider();
        UmaScimClientImpl baseClient = new UmaScimClientImpl(domain, umaMetaDataUrl, umaAatClientId, umaAatClientJwks, umaAatClientKeyId);
        return new ScimClient(baseClient);
    }

    public ScimClient(BaseScimClient baseClient) {
        this.scimClient = baseClient;
    }

    @Override
    public ScimResponse retrievePerson(String uid, String mediaType) throws HttpException, IOException {
        return this.scimClient.retrievePerson(uid, mediaType);
    }

    @Override
    public ScimResponse createPerson(ScimPerson person, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        return this.scimClient.createPerson(person, mediaType);
    }

    @Override
    public ScimResponse updatePerson(ScimPerson person, String uid, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.updatePerson(person, uid, mediaType);
    }

    @Override
    public ScimResponse deletePerson(String uid) throws HttpException, IOException {
        return this.scimClient.deletePerson(uid);
    }

    @Override
    public ScimResponse retrieveGroup(String id, String mediaType) throws HttpException, IOException {
        return this.scimClient.retrieveGroup(id, mediaType);
    }

    @Override
    public ScimResponse createGroup(ScimGroup group, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.createGroup(group, mediaType);
    }

    @Override
    public ScimResponse updateGroup(ScimGroup group, String id, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.updateGroup(group, id, mediaType);
    }

    @Override
    public ScimResponse deleteGroup(String id) throws HttpException, IOException {
        return this.scimClient.deleteGroup(id);
    }

    @Override
    public ScimResponse createPersonString(String person, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        return this.scimClient.createPersonString(person, mediaType);
    }

    @Override
    public ScimResponse updatePersonString(String person, String uid, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.updatePersonString(person, uid, mediaType);
    }

    @Override
    public ScimResponse createGroupString(String group, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.createGroupString(group, mediaType);
    }

    @Override
    public ScimResponse updateGroupString(String group, String id, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.updateGroupString(group, id, mediaType);
    }

    @Override
    public ScimResponse bulkOperation(ScimBulkOperation operation, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        return this.scimClient.bulkOperation(operation, mediaType);
    }

    @Override
    public ScimResponse bulkOperationString(String operation, String mediaType) throws HttpException, IOException {
        return this.scimClient.bulkOperationString(operation, mediaType);
    }

    @Override
    public ScimResponse retrieveAllPersons(String mediaType) throws HttpException, IOException {
        return this.scimClient.retrieveAllPersons(mediaType);
    }

    @Override
    public ScimResponse retrieveAllGroups(String mediaType) throws HttpException, IOException {
        return this.scimClient.retrieveAllGroups(mediaType);
    }

    @Override
    public ScimResponse personSearch(String attribute, String value, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        return this.scimClient.personSearch(attribute, value, mediaType);
    }

    @Override
    public ScimResponse personSearchByObject(String attribute, Object value, String valueMediaType, String outPutMediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        return this.scimClient.personSearchByObject(attribute, value, valueMediaType, outPutMediaType);
    }

    @Override
    public ScimResponse searchPersons(String attribute, String value, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        return this.scimClient.searchPersons(attribute, value, mediaType);
    }
}

