/*
 * Decompiled with CFR 0.152.
 */
package gluu.scim.client;

import gluu.scim.client.BaseScimClient;
import gluu.scim.client.ScimResponse;
import gluu.scim.client.model.ScimBulkOperation;
import gluu.scim.client.model.ScimGroup;
import gluu.scim.client.model.ScimPerson;
import gluu.scim.client.model.ScimPersonSearch;
import gluu.scim.client.util.ResponseMapper;
import gluu.scim.client.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScimClientImpl
implements BaseScimClient,
Serializable {
    private static final long serialVersionUID = 9098930517944520482L;
    private static final Logger log = LoggerFactory.getLogger(BaseScimClientImpl.class);
    private String domain;

    public BaseScimClientImpl(String domain) {
        this.domain = domain;
    }

    protected String getHost(String uri) throws MalformedURLException {
        URL url = new URL(uri);
        return url.getHost();
    }

    protected long computeAccessTokenExpirationTime(Integer expiresIn) {
        Calendar calendar = Calendar.getInstance();
        if (expiresIn != null) {
            calendar.add(13, expiresIn);
            calendar.add(13, -10);
        }
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrievePerson(String uid, String mediaType) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v1/Users/" + uid);
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        if (mediaType.equals("application/json")) {
            get.setRequestHeader("Accept", "application/json");
        }
        if (mediaType.equals("application/xml")) {
            get.setRequestHeader("Accept", "application/xml");
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createPerson(ScimPerson person, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Users/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(person), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(person, ScimPerson.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updatePerson(ScimPerson person, String uid, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v1/Users/" + uid);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        if (mediaType.equals("application/json")) {
            put.setRequestHeader("Accept", "application/json");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(person), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            put.setRequestHeader("Accept", "application/xml");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(person, ScimPerson.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse deletePerson(String uid) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        DeleteMethod delete = new DeleteMethod(this.domain + "/scim/v1/Users/" + uid);
        delete.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)delete);
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)delete);
            ScimResponse scimResponse = response = ResponseMapper.map(delete, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            delete.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveGroup(String id, String mediaType) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v1/Groups/" + id);
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        if (mediaType.equals("application/json")) {
            get.setRequestHeader("Accept", "application/json");
        }
        if (mediaType.equals("application/xml")) {
            get.setRequestHeader("Accept", "application/xml");
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createGroup(ScimGroup group, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Groups/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(group), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(group, ScimGroup.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updateGroup(ScimGroup group, String id, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v1/Groups/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        if (mediaType.equals("application/json")) {
            put.setRequestHeader("Accept", "application/json");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(group), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            put.setRequestHeader("Accept", "application/xml");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(group, ScimGroup.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse scimResponse = response = ResponseMapper.map(put, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse deleteGroup(String id) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        DeleteMethod delete = new DeleteMethod(this.domain + "/scim/v1/Groups/" + id);
        delete.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)delete);
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)delete);
            ScimResponse scimResponse = response = ResponseMapper.map(delete, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            delete.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createPersonString(String person, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Users/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(person, "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(person, "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updatePersonString(String person, String uid, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v1/Users/" + uid);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        if (mediaType.equals("application/json")) {
            put.setRequestHeader("Accept", "application/json");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(person, "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            put.setRequestHeader("Accept", "application/xml");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(person, "text/xml", "UTF-8"));
        }
        try {
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse response = ResponseMapper.map(put, null);
            put.releaseConnection();
            ScimResponse scimResponse = response;
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse createGroupString(String group, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Groups/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(group, "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(group, "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse updateGroupString(String group, String id, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PutMethod put = new PutMethod(this.domain + "/scim/v1/Groups/" + id);
        put.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)put);
        if (mediaType.equals("application/json")) {
            put.setRequestHeader("Accept", "application/json");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(group, "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            put.setRequestHeader("Accept", "application/xml");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(group, "text/xml", "UTF-8"));
        }
        try {
            httpClient.executeMethod((HttpMethod)put);
            ScimResponse response = ResponseMapper.map(put, null);
            put.releaseConnection();
            ScimResponse scimResponse = response;
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            put.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse bulkOperation(ScimBulkOperation operation, String mediaType) throws JsonGenerationException, JsonMappingException, UnsupportedEncodingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Bulk/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(operation), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(operation, ScimGroup.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse bulkOperationString(String operation, String mediaType) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Bulk/");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(operation, "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(operation, "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveAllPersons(String mediaType) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v1/Users/");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        if (mediaType.equals("application/json")) {
            get.setRequestHeader("Accept", "application/json");
        }
        if (mediaType.equals("application/xml")) {
            get.setRequestHeader("Accept", "application/xml");
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse retrieveAllGroups(String mediaType) throws HttpException, IOException {
        this.init();
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.domain + "/scim/v1/Groups/");
        get.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        this.addAuthenticationHeader((HttpMethodBase)get);
        if (mediaType.equals("application/json")) {
            get.setRequestHeader("Accept", "application/json");
        }
        if (mediaType.equals("application/xml")) {
            get.setRequestHeader("Accept", "application/xml");
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)get);
            ScimResponse scimResponse = response = ResponseMapper.map(get, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse personSearch(String attribute, String value, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Users/Search");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        ScimPersonSearch searchPattern = new ScimPersonSearch();
        searchPattern.setAttribute(attribute);
        searchPattern.setValue(value);
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(searchPattern), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(searchPattern, ScimPersonSearch.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse personSearchByObject(String attribute, Object value, String valueMediaType, String outPutMediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Users/Search");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        ScimPersonSearch searchPattern = new ScimPersonSearch();
        searchPattern.setAttribute(attribute);
        String stringValue = new String();
        if (valueMediaType.equals("application/json")) {
            stringValue = Util.getJSONString(value);
        }
        if (valueMediaType.equals("application/xml")) {
            stringValue = Util.getXMLString(value, value.getClass());
        }
        searchPattern.setValue(stringValue);
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (outPutMediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(searchPattern), "application/json", "UTF-8"));
        }
        if (outPutMediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(searchPattern, ScimPersonSearch.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScimResponse searchPersons(String attribute, String value, String mediaType) throws JsonGenerationException, JsonMappingException, IOException, JAXBException {
        this.init();
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(this.domain + "/scim/v1/Users/SearchPersons");
        post.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        ScimPersonSearch searchPattern = new ScimPersonSearch();
        searchPattern.setAttribute(attribute);
        searchPattern.setValue(value);
        this.addAuthenticationHeader((HttpMethodBase)post);
        if (mediaType.equals("application/json")) {
            post.setRequestHeader("Accept", "application/json");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getJSONString(searchPattern), "application/json", "UTF-8"));
        }
        if (mediaType.equals("application/xml")) {
            post.setRequestHeader("Accept", "application/xml");
            post.setRequestEntity((RequestEntity)new StringRequestEntity(Util.getXMLString(searchPattern, ScimPersonSearch.class), "text/xml", "UTF-8"));
        }
        try {
            ScimResponse response;
            httpClient.executeMethod((HttpMethod)post);
            ScimResponse scimResponse = response = ResponseMapper.map(post, null);
            return scimResponse;
        }
        catch (Exception ex) {
            log.error(" an Error occured : ", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    protected abstract void init();

    protected abstract void addAuthenticationHeader(HttpMethodBase var1);
}

