/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.CertificateHostnameVerifier;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

public class HostnameVerifyingTrustManager
implements X509TrustManager {
    private String[] hostnames;
    private CertificateHostnameVerifier hostnameVerifier;

    public HostnameVerifyingTrustManager(CertificateHostnameVerifier verifier, String ... names) {
        this.hostnameVerifier = verifier;
        this.hostnames = names;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateTrusted(chain[0]);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateTrusted(chain[0]);
    }

    private void checkCertificateTrusted(X509Certificate cert) throws CertificateException {
        for (String name : this.hostnames) {
            if (!this.hostnameVerifier.verify(name, cert)) continue;
            return;
        }
        throw new CertificateException(String.format("Hostname '%s' does not match the hostname in the server's certificate", Arrays.toString(this.hostnames)));
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

