/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.props.AbstractPropertyConfig;
import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import edu.vt.middleware.ldap.props.LdapProperties;
import java.io.InputStream;

public class LdapPoolConfig
extends AbstractPropertyConfig {
    public static final String PROPERTIES_DOMAIN = "edu.vt.middleware.ldap.pool.";
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKIN = false;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKOUT = false;
    public static final boolean DEFAULT_VALIDATE_PERIODICALLY = false;
    public static final long DEFAULT_VALIDATE_TIMER_PERIOD = 1800000L;
    public static final long DEFAULT_PRUNE_TIMER_PERIOD = 300000L;
    public static final long DEFAULT_EXPIRATION_TIME = 600000L;
    private static final LdapConfigPropertyInvoker PROPERTIES = new LdapConfigPropertyInvoker(LdapPoolConfig.class, "edu.vt.middleware.ldap.pool.");
    private int minPoolSize = 3;
    private int maxPoolSize = 10;
    private boolean validateOnCheckIn = false;
    private boolean validateOnCheckOut = false;
    private boolean validatePeriodically = false;
    private long validateTimerPeriod = 1800000L;
    private long pruneTimerPeriod = 300000L;
    private long expirationTime = 600000L;

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public boolean isValidateOnCheckIn() {
        return this.validateOnCheckIn;
    }

    public boolean isValidateOnCheckOut() {
        return this.validateOnCheckOut;
    }

    public boolean isValidatePeriodically() {
        return this.validatePeriodically;
    }

    public long getPruneTimerPeriod() {
        return this.pruneTimerPeriod;
    }

    public long getValidateTimerPeriod() {
        return this.validateTimerPeriod;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setMinPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting minPoolSize: " + size));
            }
            this.minPoolSize = size;
        }
    }

    public void setMaxPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting maxPoolSize: " + size));
            }
            this.maxPoolSize = size;
        }
    }

    public void setValidateOnCheckIn(boolean b) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting validateOnCheckIn: " + b));
        }
        this.validateOnCheckIn = b;
    }

    public void setValidateOnCheckOut(boolean b) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting validateOnCheckOut: " + b));
        }
        this.validateOnCheckOut = b;
    }

    public void setValidatePeriodically(boolean b) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting validatePeriodically: " + b));
        }
        this.validatePeriodically = b;
    }

    public void setPruneTimerPeriod(long time) {
        this.checkImmutable();
        if (time >= 0L) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting pruneTimerPeriod: " + time));
            }
            this.pruneTimerPeriod = time;
        }
    }

    public void setValidateTimerPeriod(long time) {
        this.checkImmutable();
        if (time >= 0L) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting validateTimerPeriod: " + time));
            }
            this.validateTimerPeriod = time;
        }
    }

    public void setExpirationTime(long time) {
        this.checkImmutable();
        if (time >= 0L) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting expirationTime: " + time));
            }
            this.expirationTime = time;
        }
    }

    public String getPropertiesDomain() {
        return PROPERTIES_DOMAIN;
    }

    public void setEnvironmentProperties(String name, String value) {
        this.checkImmutable();
        if (name != null && value != null && PROPERTIES.hasProperty(name)) {
            PROPERTIES.setProperty(this, name, value);
        }
    }

    public boolean hasEnvironmentProperty(String name) {
        return PROPERTIES.hasProperty(name);
    }

    public static LdapPoolConfig createFromProperties(InputStream is) {
        LdapPoolConfig poolConfig = new LdapPoolConfig();
        LdapProperties properties = null;
        if (is != null) {
            properties = new LdapProperties(poolConfig, is);
        } else {
            properties = new LdapProperties(poolConfig);
            properties.useDefaultPropertiesFile();
        }
        properties.configure();
        return poolConfig;
    }
}

