/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -5907239557715040242L;
    private static Logger log = LoggerFactory.getLogger(OrganizationURLTag.class);
    private static String linkText;

    public void setLinkText(String text) {
        linkText = text;
    }

    private String getOrganizationURL() {
        Organization org = this.getSPOrganization();
        if (org != null && org.getURLs() != null) {
            for (String lang : this.getBrowserLanguages()) {
                for (OrganizationURL orgURL : org.getURLs()) {
                    if (orgURL.getURL() == null || orgURL.getURL().getLanguage() == null) continue;
                    log.debug("Found OrganizationURL in Organization, language={}", (Object)orgURL.getURL().getLanguage());
                    if (!orgURL.getURL().getLanguage().equals(lang)) continue;
                    log.debug("returning OrganizationURL from Organization, {}", (Object)orgURL.getURL().getLocalString());
                    return orgURL.getURL().getLocalString();
                }
            }
            log.debug("No relevant OrganizationURL in Organization");
        }
        return null;
    }

    public int doEndTag() throws JspException {
        String orgURL = this.getOrganizationURL();
        try {
            if (null == orgURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(orgURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationURL");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

