/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session.impl;

import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.ServiceInformation;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.NameID;

public class ServiceInformationImpl
implements ServiceInformation {
    private static final long serialVersionUID = -4284509878936885637L;
    private String entityID;
    private long authenticationInstant;
    private AuthenticationMethodInformation methodInfo;
    private String nameIdentifier;
    private String nameIdentifierFormat;
    private String SPNameQualifier;
    private String nameQualifier;

    public ServiceInformationImpl(String id, DateTime loginInstant, AuthenticationMethodInformation method) {
        this.entityID = id;
        this.authenticationInstant = loginInstant.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        this.methodInfo = method;
    }

    @Override
    public synchronized String getEntityID() {
        return this.entityID;
    }

    @Override
    public synchronized DateTime getLoginInstant() {
        return new DateTime(this.authenticationInstant, (Chronology)ISOChronology.getInstanceUTC());
    }

    @Override
    public synchronized AuthenticationMethodInformation getAuthenticationMethod() {
        return this.methodInfo;
    }

    public synchronized int hashCode() {
        return this.entityID.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceInformation)) {
            return false;
        }
        ServiceInformation si = (ServiceInformation)obj;
        return this.entityID.equals(si.getEntityID());
    }

    public synchronized void setSAML2NameIdentifier(NameID nameIdentifier) {
        if (nameIdentifier != null) {
            this.nameIdentifier = nameIdentifier.getValue();
            this.nameIdentifierFormat = nameIdentifier.getFormat();
            this.nameQualifier = nameIdentifier.getNameQualifier();
            this.SPNameQualifier = nameIdentifier.getSPNameQualifier();
        }
    }

    public synchronized void setShibbolethNameIdentifier(NameIdentifier nameIdentifier) {
        if (nameIdentifier != null) {
            this.nameIdentifier = nameIdentifier.getNameIdentifier();
            this.nameIdentifierFormat = nameIdentifier.getFormat();
            this.nameQualifier = nameIdentifier.getNameQualifier();
        }
    }

    @Override
    public synchronized String getNameIdentifier() {
        return this.nameIdentifier;
    }

    @Override
    public synchronized String getNameIdentifierFormat() {
        return this.nameIdentifierFormat;
    }

    @Override
    public synchronized String getNameQualifier() {
        return this.nameQualifier;
    }

    @Override
    public synchronized String getSPNameQualifier() {
        return this.SPNameQualifier;
    }
}

