/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile;

import edu.internet2.middleware.shibboleth.common.config.BaseReloadableService;
import edu.internet2.middleware.shibboleth.common.profile.AbstractErrorHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractRequestURIMappedProfileHandler;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import edu.internet2.middleware.shibboleth.idp.authn.LoginHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class IdPProfileHandlerManager
extends BaseReloadableService
implements ProfileHandlerManager {
    private final Logger log = LoggerFactory.getLogger(IdPProfileHandlerManager.class);
    private AbstractErrorHandler errorHandler;
    private Map<String, AbstractRequestURIMappedProfileHandler> profileHandlers = new HashMap<String, AbstractRequestURIMappedProfileHandler>();
    private Map<String, LoginHandler> loginHandlers = new HashMap<String, LoginHandler>();

    public AbstractErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(AbstractErrorHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Error handler may not be null");
        }
        this.errorHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileHandler getProfileHandler(ServletRequest request) {
        ProfileHandler handler;
        String requestPath = ((HttpServletRequest)request).getPathInfo();
        this.log.debug("{}: Looking up profile handler for request path: {}", (Object)this.getId(), (Object)requestPath);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            handler = (ProfileHandler)this.profileHandlers.get(requestPath);
        }
        finally {
            readLock.unlock();
        }
        if (handler != null) {
            this.log.debug("{}: Located profile handler of the following type for the request path: {}", (Object)this.getId(), (Object)handler.getClass().getName());
        } else {
            this.log.debug("{}: No profile handler registered for request path {}", (Object)this.getId(), (Object)requestPath);
        }
        return handler;
    }

    public Map<String, AbstractRequestURIMappedProfileHandler> getProfileHandlers() {
        return this.profileHandlers;
    }

    public Map<String, LoginHandler> getLoginHandlers() {
        return this.loginHandlers;
    }

    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        this.log.debug("{}: Loading new configuration into service", (Object)this.getId());
        AbstractErrorHandler oldErrorHandler = this.errorHandler;
        Map<String, AbstractRequestURIMappedProfileHandler> oldProfileHandlers = this.profileHandlers;
        Map<String, LoginHandler> oldLoginHandlers = this.loginHandlers;
        try {
            this.loadNewErrorHandler(newServiceContext);
            this.loadNewProfileHandlers(newServiceContext);
            this.loadNewLoginHandlers(newServiceContext);
        }
        catch (Exception e) {
            this.errorHandler = oldErrorHandler;
            this.profileHandlers = oldProfileHandlers;
            this.loginHandlers = oldLoginHandlers;
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", (Throwable)e);
        }
    }

    protected void loadNewErrorHandler(ApplicationContext newServiceContext) {
        String[] errorBeanNames = newServiceContext.getBeanNamesForType(AbstractErrorHandler.class);
        this.log.debug("{}: Loading {} new error handler.", (Object)this.getId(), (Object)errorBeanNames.length);
        this.errorHandler = (AbstractErrorHandler)newServiceContext.getBean(errorBeanNames[0]);
        this.log.debug("{}: Loaded new error handler of type: {}", (Object)this.getId(), (Object)this.errorHandler.getClass().getName());
    }

    protected void loadNewProfileHandlers(ApplicationContext newServiceContext) {
        String[] profileBeanNames = newServiceContext.getBeanNamesForType(AbstractRequestURIMappedProfileHandler.class);
        this.log.debug("{}: Loading {} new profile handlers.", (Object)this.getId(), (Object)profileBeanNames.length);
        HashMap<String, AbstractRequestURIMappedProfileHandler> newProfileHandlers = new HashMap<String, AbstractRequestURIMappedProfileHandler>();
        for (String profileBeanName : profileBeanNames) {
            AbstractRequestURIMappedProfileHandler profileHandler = (AbstractRequestURIMappedProfileHandler)newServiceContext.getBean(profileBeanName);
            for (String requestPath : profileHandler.getRequestPaths()) {
                newProfileHandlers.put(requestPath, profileHandler);
                this.log.debug("{}: Loaded profile handler for handling requests to request path {}", (Object)this.getId(), (Object)requestPath);
            }
        }
        this.profileHandlers = newProfileHandlers;
    }

    protected void loadNewLoginHandlers(ApplicationContext newServiceContext) {
        String[] authnBeanNames = newServiceContext.getBeanNamesForType(LoginHandler.class);
        this.log.debug("{}: Loading {} new authentication handlers.", (Object)this.getId(), (Object)authnBeanNames.length);
        HashMap<String, LoginHandler> newLoginHandlers = new HashMap<String, LoginHandler>();
        for (String authnBeanName : authnBeanNames) {
            LoginHandler authnHandler = (LoginHandler)newServiceContext.getBean(authnBeanName);
            this.log.debug("{}: Loading authentication handler of type supporting authentication methods: {}", (Object)this.getId(), authnHandler.getSupportedAuthenticationMethods());
            for (String authnMethod : authnHandler.getSupportedAuthenticationMethods()) {
                newLoginHandlers.put(authnMethod, authnHandler);
            }
        }
        this.loginHandlers = newLoginHandlers;
    }
}

