/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUserLoginHandler
extends AbstractLoginHandler {
    private final Logger log = LoggerFactory.getLogger(RemoteUserLoginHandler.class);
    private String servletURL;

    public void setServletURL(String url) {
        this.servletURL = url;
    }

    public String getServletURL() {
        return this.servletURL;
    }

    @Override
    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String profileUrl = HttpServletHelper.getContextRelativeUrl(httpRequest, this.servletURL).buildURL();
            this.log.debug("Redirecting to {}", (Object)profileUrl);
            httpResponse.sendRedirect(profileUrl);
            return;
        }
        catch (IOException ex) {
            this.log.error("Unable to redirect to remote user authentication servlet.", (Throwable)ex);
            return;
        }
    }
}

