/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile.provider;

import edu.internet2.middleware.shibboleth.common.profile.AbstractErrorHandler;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSPErrorHandler
extends AbstractErrorHandler {
    private final Logger log = LoggerFactory.getLogger(JSPErrorHandler.class);
    private String jspPage;

    public JSPErrorHandler(String page) {
        this.jspPage = DatatypeHelper.safeTrimOrNullString((String)page);
        if (this.jspPage == null) {
            throw new IllegalArgumentException("JSP Error page may not be null.");
        }
    }

    @Override
    public void processRequest(InTransport in, OutTransport out) {
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)in).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)out).getWrappedResponse();
        RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(this.jspPage);
        try {
            dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (Throwable t) {
            this.log.error("Could not dispatch to error JSP page: " + this.jspPage, t);
            return;
        }
    }
}

