/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXX509CredentialTrustEngine;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class StaticPKIXX509CredentialTrustEngineFactoryBean
extends AbstractFactoryBean {
    private List<PKIXValidationInformation> pkixInfo;
    private Set<String> trustedNames;
    private PKIXValidationOptions pkixOptions;

    public PKIXValidationOptions getPKIXValidationOptions() {
        return this.pkixOptions;
    }

    public void setPKIXValidationOptions(PKIXValidationOptions newOptions) {
        this.pkixOptions = newOptions;
    }

    public List<PKIXValidationInformation> getPKIXInfo() {
        return this.pkixInfo;
    }

    public void setPKIXInfo(List<PKIXValidationInformation> newPKIXInfo) {
        this.pkixInfo = newPKIXInfo;
    }

    public Set<String> getTrustedNames() {
        return this.trustedNames;
    }

    public void setTrustedNames(Set<String> newTrustedNames) {
        this.trustedNames = newTrustedNames;
    }

    public Class getObjectType() {
        return PKIXX509CredentialTrustEngine.class;
    }

    protected Object createInstance() throws Exception {
        Set<String> names = this.getTrustedNames();
        if (names == null) {
            names = Collections.emptySet();
        }
        StaticPKIXValidationInformationResolver pkixResolver = new StaticPKIXValidationInformationResolver(this.getPKIXInfo(), names);
        PKIXX509CredentialTrustEngine engine = new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)pkixResolver);
        if (this.getPKIXValidationOptions() != null) {
            ((CertPathPKIXTrustEvaluator)engine.getPKIXTrustEvaluator()).setPKIXValidationOptions(this.getPKIXValidationOptions());
        }
        return engine;
    }
}

