/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.relyingparty;

import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import java.util.List;
import java.util.Map;
import org.opensaml.xml.security.credential.Credential;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class RelyingPartyFactoryBean
extends AbstractFactoryBean {
    private String relyingPartyId;
    private String providerId;
    private String defaultAuthenticationMethod;
    private Credential defaultSigningCredential;
    private List<String> nameIdFormatPrecedence;
    private List<ProfileConfiguration> profileConfigurations;

    public Class getObjectType() {
        return RelyingPartyConfiguration.class;
    }

    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    public void setRelyingPartyId(String id) {
        this.relyingPartyId = id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String id) {
        this.providerId = id;
    }

    public String getDefaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public void setDefaultAuthenticationMethod(String method) {
        this.defaultAuthenticationMethod = method;
    }

    public Credential getDefaultSigningCredential() {
        return this.defaultSigningCredential;
    }

    public void setDefaultSigningCredential(Credential credential) {
        this.defaultSigningCredential = credential;
    }

    public List<String> getNameIdFormatPrecedence() {
        return this.nameIdFormatPrecedence;
    }

    public void setNameIdFormatPrecedence(List<String> precedence) {
        this.nameIdFormatPrecedence = precedence;
    }

    public List<ProfileConfiguration> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    public void setProfileConfigurations(List<ProfileConfiguration> configurations) {
        this.profileConfigurations = configurations;
    }

    protected Object createInstance() throws Exception {
        RelyingPartyConfiguration configuration = new RelyingPartyConfiguration(this.relyingPartyId, this.providerId);
        configuration.setDefaultAuthenticationMethod(this.defaultAuthenticationMethod);
        configuration.setDefaultSigningCredential(this.defaultSigningCredential);
        if (this.nameIdFormatPrecedence != null && !this.nameIdFormatPrecedence.isEmpty()) {
            configuration.setNameIdFormatPrecedence(this.nameIdFormatPrecedence.toArray(new String[this.nameIdFormatPrecedence.size()]));
        }
        if (this.profileConfigurations != null) {
            Map<String, ProfileConfiguration> registeredProfileConfigs = configuration.getProfileConfigurations();
            for (ProfileConfiguration profileConfig : this.profileConfigurations) {
                registeredProfileConfigs.put(profileConfig.getProfileId(), profileConfig);
            }
        }
        return configuration;
    }
}

