/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.profile;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.w3c.dom.Element;

public abstract class AbstractRequestURIMappedProfileHandlerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(AbstractRequestURIMappedProfileHandlerBeanDefinitionParser.class);

    protected void doParse(Element config, BeanDefinitionBuilder builder) {
        log.info("Parsing configuration for profile handler: {}", (Object)XMLHelper.getXSIType((Element)config).getLocalPart());
        builder.addPropertyValue("requestPaths", this.getRequestPaths(config));
    }

    protected List<String> getRequestPaths(Element config) {
        ArrayList<String> requestPaths = new ArrayList<String>();
        List requestPathElems = XMLHelper.getChildElementsByTagName((Element)config, (String)"RequestPath");
        if (requestPathElems != null) {
            for (Element requestPathElem : requestPathElems) {
                requestPaths.add(DatatypeHelper.safeTrimOrNullString((String)requestPathElem.getTextContent()));
            }
        }
        return requestPaths;
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

