/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.AbstractResolutionPlugInBeanDefinitionParser;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseDataConnectorBeanDefinitionParser
extends AbstractResolutionPlugInBeanDefinitionParser {
    public static final QName FAILOVER_DATA_CONNECTOR_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "FailoverDataConnector");
    private final Logger log = LoggerFactory.getLogger(BaseDataConnectorBeanDefinitionParser.class);

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        List<Element> failoverConnector = pluginConfigChildren.get(FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            String connectorId = DatatypeHelper.safeTrimOrNullString((String)failoverConnector.get(0).getAttributeNS(null, "ref"));
            this.log.debug("Setting the following failover data connector dependencies for plugin {}: {}", (Object)pluginId, (Object)connectorId);
            pluginBuilder.addPropertyValue("failoverDataConnectorIds", (Object)connectorId);
        }
    }
}

