/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.BasePrincipalConnector;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.util.DataExpiredException;
import edu.internet2.middleware.shibboleth.common.util.DataSealer;
import edu.internet2.middleware.shibboleth.common.util.DataSealerException;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoTransientPrincipalConnector
extends BasePrincipalConnector {
    private static Logger log = LoggerFactory.getLogger(CryptoTransientPrincipalConnector.class);
    private DataSealer dataSealer;

    public CryptoTransientPrincipalConnector(DataSealer sealer) {
        if (sealer == null) {
            throw new IllegalArgumentException("DataSealer may not be null.");
        }
        this.dataSealer = sealer;
    }

    @Override
    public String resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String decodedId;
        NameIdentifier nameId;
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        String transientId = null;
        String nameQualifier = null;
        String spNameQualifier = null;
        SAMLObject subjectId = requestContext.getSubjectNameIdentifier();
        if (subjectId instanceof NameIdentifier) {
            nameId = (NameIdentifier)requestContext.getSubjectNameIdentifier();
            if (nameId != null) {
                transientId = nameId.getNameIdentifier();
                nameQualifier = nameId.getNameQualifier();
            }
        } else if (requestContext.getSubjectNameIdentifier() instanceof NameID) {
            nameId = (NameID)requestContext.getSubjectNameIdentifier();
            if (nameId != null) {
                transientId = nameId.getValue();
                nameQualifier = nameId.getNameQualifier();
                spNameQualifier = nameId.getSPNameQualifier();
            }
        } else {
            throw new AttributeResolutionException("Subject name identifier is not of a supported type");
        }
        if (transientId == null) {
            throw new AttributeResolutionException("Invalid subject name identifier");
        }
        try {
            decodedId = this.dataSealer.unwrap(transientId);
        }
        catch (DataExpiredException e) {
            throw new AttributeResolutionException("Principal identifier has expired.");
        }
        catch (DataSealerException e) {
            throw new AttributeResolutionException("Caught exception unwrapping principal identifier.", e);
        }
        if (decodedId == null) {
            throw new AttributeResolutionException("Unable to recover principal from transient identifier: " + transientId);
        }
        String[] parts = decodedId.split("!");
        if (parts.length != 3) {
            throw new AttributeResolutionException("Decoded principal information was invalid: " + decodedId);
        }
        if (nameQualifier != null && !nameQualifier.equals(parts[0])) {
            throw new AttributeResolutionException("Decoded NameQualifier (" + nameQualifier + ") does not match supplied value (" + parts[0] + ").");
        }
        if (spNameQualifier != null && !spNameQualifier.equals(parts[1])) {
            throw new AttributeResolutionException("Decoded SPNameQualifier (" + spNameQualifier + ") does not match supplied value (" + parts[1] + ").");
        }
        if (!parts[0].equals(requestContext.getOutboundMessageIssuer())) {
            throw new AttributeResolutionException("Decoded NameQualifier (" + parts[0] + ") does not match issuer (" + requestContext.getOutboundMessageIssuer() + ").");
        }
        if (!parts[1].equals(requestContext.getInboundMessageIssuer())) {
            throw new AttributeResolutionException("Decoded SPNameQualifier (" + parts[0] + ") does not match requester (" + requestContext.getInboundMessageIssuer() + ").");
        }
        return parts[2];
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.dataSealer == null) {
            log.error("CryptoTransientPrincipalConnector (" + this.getId() + ") must have a DataSealer object set.");
            throw new AttributeResolutionException("CryptoTransientPrincipalConnector (" + this.getId() + ") must have a DataSealer object set.");
        }
    }
}

