/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticDataConnector
extends BaseDataConnector {
    private Map<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();

    public StaticDataConnector(List<BaseAttribute<String>> staticAttributes) {
        if (staticAttributes != null) {
            for (BaseAttribute<String> attribute : staticAttributes) {
                this.attributes.put(attribute.getId(), attribute);
            }
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        if (null == this.attributes) {
            return null;
        }
        HashMap<String, BaseAttribute> result = new HashMap<String, BaseAttribute>(this.attributes.size());
        for (BaseAttribute attr : this.attributes.values()) {
            BasicAttribute copy = new BasicAttribute(attr.getId());
            copy.getDisplayDescriptions().putAll(attr.getDisplayDescriptions());
            copy.getDisplayNames().putAll(attr.getDisplayNames());
            copy.setValueComparator(attr.getValueComparator());
            copy.setValues(attr.getValues());
            result.put(attr.getId(), copy);
        }
        return result;
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

