/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.saml;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityGroupMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AbstractEntityGroupMatchFunctor.class);
    private String entityGroup;

    public String getEntityGroup() {
        return this.entityGroup;
    }

    public void setEntityGroup(String group) {
        this.entityGroup = DatatypeHelper.safeTrimOrNullString((String)group);
    }

    protected boolean isEntityInGroup(EntityDescriptor entity) {
        if (this.entityGroup == null) {
            this.log.debug("No entity group specified, unable to check if entity is in group");
            return false;
        }
        if (entity == null) {
            this.log.debug("No entity metadata available, unable to check if entity is in group {}", (Object)this.entityGroup);
            return false;
        }
        EntitiesDescriptor currentGroup = (EntitiesDescriptor)entity.getParent();
        if (currentGroup == null) {
            this.log.debug("Entity descriptor does not have a parent object, unable to check if entity is in group {}", (Object)this.entityGroup);
            return false;
        }
        do {
            if (!this.entityGroup.equals(currentGroup.getName())) continue;
            return true;
        } while ((currentGroup = (EntitiesDescriptor)currentGroup.getParent()) != null);
        return false;
    }
}

