/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(ScriptMatchFunctor.class);
    private String scriptLanguage;
    private String script;
    private ScriptEngine scriptEngine;
    private CompiledScript compiledScript;

    public ScriptMatchFunctor(String language, String newScript) {
        this.scriptLanguage = language;
        this.script = newScript;
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName(this.scriptLanguage);
        this.compileScript();
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        ScriptContext context = this.getScriptContext(filterContext, attributeId, attributeValue);
        return this.executeScript(context);
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        ScriptContext context = this.getScriptContext(filterContext, null, null);
        return this.executeScript(context);
    }

    protected void compileScript() {
        if (DatatypeHelper.isEmpty((String)this.script)) {
            return;
        }
        try {
            if (this.scriptEngine != null && this.scriptEngine instanceof Compilable) {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.script);
            }
        }
        catch (ScriptException e) {
            this.compiledScript = null;
            this.log.warn("Unable to pre-compile JSR-268 script: " + this.script, (Throwable)e);
        }
    }

    protected ScriptContext getScriptContext(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("filterContext", filterContext, 100);
        scriptContext.setAttribute("attributeId", attributeId, 100);
        scriptContext.setAttribute("attributeValue", attributeValue, 100);
        return scriptContext;
    }

    protected Boolean executeScript(ScriptContext scriptContext) throws FilterProcessingException {
        try {
            Boolean result = this.compiledScript != null ? (Boolean)this.compiledScript.eval(scriptContext) : (Boolean)this.scriptEngine.eval(this.script, scriptContext);
            if (result != null) {
                return (boolean)result;
            }
            return Boolean.FALSE;
        }
        catch (ScriptException e) {
            throw new FilterProcessingException("Unable to execute match functor script", e);
        }
    }
}

