/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractSAML1AttributeEncoder;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeValue;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1Base64AttributeEncoder
extends AbstractSAML1AttributeEncoder {
    private final Logger log = LoggerFactory.getLogger(SAML1Base64AttributeEncoder.class);
    private final XMLObjectBuilder<XSString> stringBuilder = Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);

    @Override
    public Attribute encode(BaseAttribute attribute) {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        this.populateAttribute(samlAttribute);
        for (Object o : attribute.getValues()) {
            if (o == null || !(o instanceof byte[])) {
                this.log.debug("Skipping attribute value because it is either null or not a byte[]");
                continue;
            }
            byte[] attributeValue = (byte[])o;
            XSString samlAttributeValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            samlAttributeValue.setValue(Base64.encodeBytes((byte[])attributeValue));
            samlAttribute.getAttributeValues().add(samlAttributeValue);
        }
        List attributeValues = samlAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Unable to encode {} attribute.  It does not contain any values", (Object)attribute.getId());
            return null;
        }
        return samlAttribute;
    }
}

