package com.wikidsystems.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * Created by
 * User: els
 * Date: 4/12/11
 * Time: 10:25 AM
 */
public class Example {

    public static void main(String[] args) {
        testResources();

        if (args.length < 6) {
            System.out.println("Usage: com.wikidsystems.client.Example Host Port Key_File Key_File_Pass CA_Store CA_Store_Pass");
            System.exit(1);
        }
        new Example(args);
    }

    public Example(String[] args) {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String keyfile = args[2];
        String pass = args[3];
        String caStore = args[4];
        String caStorePass = args[5];

        try {
            wClient wc = new wClient(host, port, keyfile, pass, caStore, caStorePass);

            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Domain Code:");
            String dom = in.readLine();
            System.out.println("Userid:");
            String uid = in.readLine();
            System.out.println("Passcode:");
            String passcode = in.readLine();

            if(wc.CheckCredentials(uid,passcode,dom)){
                System.out.println("Authentication SUCCEEDED");
            } else {
                System.out.println("Authentication FAILED");
                System.exit(128);
            }
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static void testResources() {
        try {
            Class.forName("com.wikidsystems.client.wClient");
        } catch (Throwable e) {
            System.out.println("Could not load class com.wikidsystems.client.wClient.  Please ensure the wClient jar is included in the classpath.");
            System.exit(255);
        }

        try {
            Class.forName("org.apache.log4j.Logger");
        } catch (Throwable e) {
            System.out.println("Could not load class org.apache.log4j.Logger.  Please ensure the log4j library is included in the classpath.");
            System.exit(255);
        }

        try {
            Class.forName("org.jdom.Document");
        } catch (Throwable e) {
            System.out.println("Could not load class org.jdom.Document.  Please ensure the jdom library is included in the classpath.");
            System.exit(255);
        }

        try {
            Class.forName("com.thoughtworks.xstream.XStream");
        } catch (Throwable e) {
            System.out.println("Could not load class com.thoughtworks.xstream.XStream.  Please ensure the XStream library is included in the classpath.");
            System.exit(255);
        }

    }
}
