/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Locale;

public class LocaleBCP47 {
    private String language = "";
    private String script = "";
    private String region = "";
    public static final String SEP = "-";

    public static LocaleBCP47 parse(String languageTag) {
        int index;
        if (languageTag == null || languageTag.isEmpty()) {
            return null;
        }
        String[] tokens = languageTag.split(SEP);
        if (!LocaleBCP47.isLanguage(tokens[index = 0])) {
            return null;
        }
        LocaleBCP47 langtag = new LocaleBCP47();
        langtag.setLanguage(tokens[index++]);
        int count = 0;
        while (index < tokens.length && count++ != 3 && LocaleBCP47.isExtlang(tokens[index])) {
            ++index;
        }
        if (index != tokens.length && LocaleBCP47.isScript(tokens[index])) {
            langtag.setScript(tokens[index++]);
        }
        if (index != tokens.length && LocaleBCP47.isRegion(tokens[index])) {
            langtag.setRegion(tokens[index]);
        }
        langtag.addRegion();
        return langtag;
    }

    public String toLangtag() {
        return this.toLangtag(this.language);
    }

    public String toLangtag(String lang) {
        if (this.region.equals("")) {
            return lang;
        }
        return lang + SEP + this.region;
    }

    private void setLanguage(String language) {
        String lang;
        this.language = lang = language.toLowerCase(Locale.US);
    }

    private void setScript(String script) {
        this.script = script.substring(0, 1).toUpperCase(Locale.US) + script.substring(1).toLowerCase(Locale.US);
    }

    private void setRegion(String region) {
        this.region = region.toUpperCase(Locale.US);
    }

    private void addRegion() {
        if (this.language.equals("zh") && this.region.isEmpty()) {
            if (this.script.equals("Hant")) {
                this.region = "TW";
                return;
            }
            if (this.script.equals("Hans")) {
                this.region = "CN";
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRegion() {
        return this.region;
    }

    private static boolean isLanguage(String s) {
        return s.length() >= 2 && s.length() <= 8 && LocaleBCP47.isAlphaString(s);
    }

    private static boolean isExtlang(String s) {
        return s.length() == 3 && LocaleBCP47.isAlphaString(s);
    }

    private static boolean isScript(String s) {
        return s.length() == 4 && LocaleBCP47.isAlphaString(s);
    }

    private static boolean isRegion(String s) {
        return s.length() == 2 && LocaleBCP47.isAlphaString(s) || s.length() == 3 && LocaleBCP47.isNumericString(s);
    }

    private static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleBCP47.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isNumericString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleBCP47.isNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }
}

