/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuppressWithNearbyCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_COMMENT_FORMAT = "SUPPRESS CHECKSTYLE (\\w+)";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private static final String DEFAULT_MESSAGE_FORMAT = null;
    private static final String DEFAULT_INFLUENCE_FORMAT = "0";
    private boolean mCheckC = true;
    private boolean mCheckCPP = true;
    private Pattern mCommentRegexp;
    private String mCheckFormat;
    private Pattern mCheckRegexp;
    private String mMessageFormat;
    private String mInfluenceFormat;
    private final List<Tag> mTags = Lists.newArrayList();
    private WeakReference<FileContents> mFileContentsReference = new WeakReference<Object>(null);

    public SuppressWithNearbyCommentFilter() {
        if (DEFAULT_COMMENT_FORMAT != null) {
            this.setCommentFormat(DEFAULT_COMMENT_FORMAT);
        }
        if (DEFAULT_CHECK_FORMAT != null) {
            this.setCheckFormat(DEFAULT_CHECK_FORMAT);
        }
        if (DEFAULT_MESSAGE_FORMAT != null) {
            this.setMessageFormat(DEFAULT_MESSAGE_FORMAT);
        }
        if (DEFAULT_INFLUENCE_FORMAT != null) {
            this.setInfluenceFormat(DEFAULT_INFLUENCE_FORMAT);
        }
    }

    public void setCommentFormat(String aFormat) throws ConversionException {
        try {
            this.mCommentRegexp = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public FileContents getFileContents() {
        return (FileContents)this.mFileContentsReference.get();
    }

    public void setFileContents(FileContents aFileContents) {
        this.mFileContentsReference = new WeakReference<FileContents>(aFileContents);
    }

    public void setCheckFormat(String aFormat) throws ConversionException {
        try {
            this.mCheckRegexp = Utils.getPattern(aFormat);
            this.mCheckFormat = aFormat;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setMessageFormat(String aFormat) throws ConversionException {
        try {
            Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
        this.mMessageFormat = aFormat;
    }

    public void setInfluenceFormat(String aFormat) throws ConversionException {
        try {
            Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
        this.mInfluenceFormat = aFormat;
    }

    public void setCheckCPP(boolean aCheckCPP) {
        this.mCheckCPP = aCheckCPP;
    }

    public void setCheckC(boolean aCheckC) {
        this.mCheckC = aCheckC;
    }

    @Override
    public boolean accept(AuditEvent aEvent) {
        if (aEvent.getLocalizedMessage() == null) {
            return true;
        }
        FileContents currentContents = FileContentsHolder.getContents();
        if (currentContents == null) {
            return true;
        }
        if (this.getFileContents() != currentContents) {
            this.setFileContents(currentContents);
            this.tagSuppressions();
        }
        for (Tag tag : this.mTags) {
            if (!tag.isMatch(aEvent)) continue;
            return false;
        }
        return true;
    }

    private void tagSuppressions() {
        this.mTags.clear();
        FileContents contents = this.getFileContents();
        if (this.mCheckCPP) {
            this.tagSuppressions((Collection<TextBlock>)contents.getCppComments().values());
        }
        if (this.mCheckC) {
            ImmutableCollection cComments = contents.getCComments().values();
            for (List element : cComments) {
                this.tagSuppressions(element);
            }
        }
        Collections.sort(this.mTags);
    }

    private void tagSuppressions(Collection<TextBlock> aComments) {
        for (TextBlock comment : aComments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String aText, int aLine, int aColumn) {
        Matcher matcher = this.mCommentRegexp.matcher(aText);
        if (matcher.find()) {
            this.addTag(matcher.group(0), aLine);
        }
    }

    private void addTag(String aText, int aLine) {
        Tag tag = new Tag(aText, aLine);
        this.mTags.add(tag);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Tag
    implements Comparable<Tag> {
        private final String mText;
        private int mFirstLine;
        private int mLastLine;
        private Pattern mTagCheckRegexp;
        private Pattern mTagMessageRegexp;

        public Tag(String aText, int aLine) throws ConversionException {
            this.mText = aText;
            this.mTagCheckRegexp = SuppressWithNearbyCommentFilter.this.mCheckRegexp;
            String format = "";
            try {
                format = this.expandFromComment(aText, SuppressWithNearbyCommentFilter.this.mCheckFormat, SuppressWithNearbyCommentFilter.this.mCommentRegexp);
                this.mTagCheckRegexp = Pattern.compile(format);
                if (SuppressWithNearbyCommentFilter.this.mMessageFormat != null) {
                    format = this.expandFromComment(aText, SuppressWithNearbyCommentFilter.this.mMessageFormat, SuppressWithNearbyCommentFilter.this.mCommentRegexp);
                    this.mTagMessageRegexp = Pattern.compile(format);
                }
                int influence = 0;
                if (SuppressWithNearbyCommentFilter.this.mInfluenceFormat != null) {
                    format = this.expandFromComment(aText, SuppressWithNearbyCommentFilter.this.mInfluenceFormat, SuppressWithNearbyCommentFilter.this.mCommentRegexp);
                    try {
                        if (format.startsWith("+")) {
                            format = format.substring(1);
                        }
                        influence = Integer.parseInt(format);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("unable to parse influence from '" + aText + "' using " + SuppressWithNearbyCommentFilter.this.mInfluenceFormat, (Throwable)e);
                    }
                }
                if (influence >= 0) {
                    this.mFirstLine = aLine;
                    this.mLastLine = aLine + influence;
                } else {
                    this.mFirstLine = aLine + influence;
                    this.mLastLine = aLine;
                }
            }
            catch (PatternSyntaxException e) {
                throw new ConversionException("unable to parse expanded comment " + format, (Throwable)e);
            }
        }

        public String getText() {
            return this.mText;
        }

        public int getFirstLine() {
            return this.mFirstLine;
        }

        public int getLastLine() {
            return this.mLastLine;
        }

        @Override
        public int compareTo(Tag aOther) {
            if (this.mFirstLine == aOther.mFirstLine) {
                return this.mLastLine - aOther.mLastLine;
            }
            return this.mFirstLine - aOther.mFirstLine;
        }

        public boolean isMatch(AuditEvent aEvent) {
            int line = aEvent.getLine();
            if (line < this.mFirstLine) {
                return false;
            }
            if (line > this.mLastLine) {
                return false;
            }
            Matcher tagMatcher = this.mTagCheckRegexp.matcher(aEvent.getSourceName());
            if (tagMatcher.find()) {
                return true;
            }
            if (this.mTagMessageRegexp != null) {
                Matcher messageMatcher = this.mTagMessageRegexp.matcher(aEvent.getMessage());
                return messageMatcher.find();
            }
            return false;
        }

        private String expandFromComment(String aComment, String aString, Pattern aRegexp) {
            Matcher matcher = aRegexp.matcher(aComment);
            if (!matcher.find()) {
                return aString;
            }
            String result = aString;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
            return result;
        }

        public final String toString() {
            return "Tag[lines=[" + this.getFirstLine() + " to " + this.getLastLine() + "]; text='" + this.getText() + "']";
        }
    }
}

