/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp;

import com.google.common.base.Preconditions;
import com.lochbridge.oath.otp.HmacShaAlgorithm;
import com.lochbridge.oath.otp.TOTP;
import com.lochbridge.oath.otp.TOTPBuilder;

public final class TOTPValidator {
    public static final int DEFAULT_WINDOW = 1;
    private final int window;

    private TOTPValidator(int window) {
        Preconditions.checkArgument((window >= 0 ? 1 : 0) != 0);
        this.window = window;
    }

    public static TOTPValidator defaultWindow() {
        return TOTPValidator.window(1);
    }

    public static TOTPValidator window(int window) {
        return new TOTPValidator(window);
    }

    public boolean isValid(byte[] key, long timeStep, int digits, HmacShaAlgorithm hmacShaAlgorithm, String value) {
        return this.isValid(key, timeStep, digits, hmacShaAlgorithm, value, System.currentTimeMillis());
    }

    public boolean isValid(byte[] key, long timeStep, int digits, HmacShaAlgorithm hmacShaAlgorithm, String value, long validationTime) {
        boolean result = false;
        TOTPBuilder builder = TOTP.key(key).timeStep(timeStep).digits(digits).hmacSha(hmacShaAlgorithm);
        for (int i = -this.window; i <= this.window; ++i) {
            long time = validationTime + (long)i * timeStep;
            TOTP vtotp = builder.build(time);
            if (!vtotp.value().equals(value)) continue;
            result = true;
            break;
        }
        return result;
    }
}

