/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import com.google.common.io.BaseEncoding;
import com.lochbridge.oath.otp.HmacShaAlgorithm;
import com.lochbridge.oath.otp.TOTP;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class TOTPBuilder {
    public static final long DEFAULT_TIME_STEP = TimeUnit.SECONDS.toMillis(30L);
    public static final int DEFAULT_DIGITS = 6;
    public static final int MIN_ALLOWED_DIGITS = 6;
    public static final int MAX_ALLOWED_DIGITS = 8;
    private final byte[] key;
    private long timeStep = DEFAULT_TIME_STEP;
    private int digits = 6;
    private HmacShaAlgorithm hmacShaAlgorithm = HmacShaAlgorithm.HMAC_SHA_1;

    TOTPBuilder(byte[] key) {
        Preconditions.checkNotNull((Object)key);
        this.key = new byte[key.length];
        System.arraycopy(key, 0, this.key, 0, key.length);
    }

    public TOTPBuilder timeStep(long timeStep) {
        Preconditions.checkArgument((timeStep > 0L ? 1 : 0) != 0);
        this.timeStep = timeStep;
        return this;
    }

    public TOTPBuilder digits(int digits) {
        Preconditions.checkArgument((boolean)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)).contains((Comparable)Integer.valueOf(digits)));
        this.digits = digits;
        return this;
    }

    public TOTPBuilder hmacSha(HmacShaAlgorithm algorithm) {
        Preconditions.checkNotNull((Object)((Object)algorithm));
        this.hmacShaAlgorithm = algorithm;
        return this;
    }

    public TOTPBuilder hmacSha1() {
        return this.hmacSha(HmacShaAlgorithm.HMAC_SHA_1);
    }

    public TOTPBuilder hmacSha256() {
        return this.hmacSha(HmacShaAlgorithm.HMAC_SHA_256);
    }

    public TOTPBuilder hmacSha512() {
        return this.hmacSha(HmacShaAlgorithm.HMAC_SHA_512);
    }

    public TOTP build() {
        long time = System.currentTimeMillis();
        return new TOTP(this.generateTOTP(time), time, this.hmacShaAlgorithm, this.digits, this.timeStep);
    }

    public TOTP build(long time) {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0);
        return new TOTP(this.generateTOTP(time), time, this.hmacShaAlgorithm, this.digits, this.timeStep);
    }

    private byte[] computeHmacSha(byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(this.hmacShaAlgorithm.getAlgorithm());
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private String generateTOTP(long time) {
        long tc = (long)Math.floor(time / this.timeStep);
        String timeInHex = Strings.padStart((String)Long.toHexString(tc).toUpperCase(), (int)16, (char)'0');
        byte[] msg = BaseEncoding.base16().decode((CharSequence)timeInHex);
        byte[] hash = this.computeHmacSha(this.key, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % (int)Math.pow(10.0, this.digits);
        return Strings.padStart((String)Integer.toString(otp), (int)this.digits, (char)'0');
    }
}

