/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp;

public enum HmacShaAlgorithm {
    HMAC_SHA_1("HmacSHA1"),
    HMAC_SHA_256("HmacSHA256"),
    HMAC_SHA_512("HmacSHA512");

    private final String algorithm;

    private HmacShaAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static HmacShaAlgorithm from(String algorithm) {
        for (HmacShaAlgorithm alg : HmacShaAlgorithm.values()) {
            if (!alg.algorithm.equals(algorithm)) continue;
            return alg;
        }
        throw new IllegalArgumentException("No matching HmacShaAlgorithm constant for [" + algorithm + "]");
    }

    public String toString() {
        return this.getAlgorithm();
    }
}

