/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp;

import com.google.common.base.Preconditions;
import com.lochbridge.oath.otp.HOTP;
import com.lochbridge.oath.otp.HOTPBuilder;
import com.lochbridge.oath.otp.HOTPValidationResult;

public final class HOTPValidator {
    public static final int DEFAULT_LOOK_AHEAD_WINDOW = 2;
    private final int lookAheadWindow;

    private HOTPValidator(int lookAheadWindow) {
        Preconditions.checkArgument((lookAheadWindow >= 1 ? 1 : 0) != 0);
        this.lookAheadWindow = lookAheadWindow;
    }

    public static HOTPValidator defaultLookAheadWindow() {
        return HOTPValidator.lookAheadWindow(2);
    }

    public static HOTPValidator lookAheadWindow(int lookAheadWindow) {
        return new HOTPValidator(lookAheadWindow);
    }

    public HOTPValidationResult validate(byte[] key, long movingFactor, int digits, String value) {
        HOTPBuilder builder = HOTP.key(key).digits(digits);
        for (int i = 0; i <= this.lookAheadWindow; ++i) {
            HOTP vhotp = builder.movingFactor(movingFactor + (long)i).build();
            if (!vhotp.value().equals(value)) continue;
            return new HOTPValidationResult(true, vhotp.movingFactor() + 1L);
        }
        return new HOTPValidationResult(false, movingFactor);
    }
}

