/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import com.lochbridge.oath.otp.HOTP;
import com.lochbridge.oath.otp.HmacShaAlgorithm;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HOTPBuilder {
    public static final int DEFAULT_DIGITS = 6;
    public static final int MIN_ALLOWED_DIGITS = 6;
    public static final int MAX_ALLOWED_DIGITS = 8;
    private final byte[] key;
    private long movingFactor = 0L;
    private int digits = 6;

    HOTPBuilder(byte[] key) {
        Preconditions.checkNotNull((Object)key);
        this.key = new byte[key.length];
        System.arraycopy(key, 0, this.key, 0, key.length);
    }

    public HOTPBuilder movingFactor(long movingFactor) {
        Preconditions.checkArgument((movingFactor >= 0L ? 1 : 0) != 0);
        this.movingFactor = movingFactor;
        return this;
    }

    public HOTPBuilder digits(int digits) {
        Preconditions.checkArgument((boolean)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)).contains((Comparable)Integer.valueOf(digits)));
        this.digits = digits;
        return this;
    }

    public HOTP build() {
        byte[] text = ByteBuffer.allocate(8).putLong(this.movingFactor).array();
        byte[] hash = this.computeHmacSha1(this.key, text);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % (int)Math.pow(10.0, this.digits);
        String hotp = Strings.padStart((String)Integer.toString(otp), (int)this.digits, (char)'0');
        return new HOTP(hotp, this.digits, this.movingFactor);
    }

    private byte[] computeHmacSha1(byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(HmacShaAlgorithm.HMAC_SHA_1.getAlgorithm());
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }
}

