/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp.keyprovisioning.qrcode;

import com.google.common.base.Preconditions;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.lochbridge.oath.otp.keyprovisioning.OTPAuthURI;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Hashtable;

public class QRCodeWriter {
    private final OTPAuthURI uri;
    private int width = 250;
    private int height = 250;
    private ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
    private int margin = 4;
    private String imageFormatName = "PNG";

    private QRCodeWriter(OTPAuthURI uri) {
        this.uri = uri;
    }

    public static QRCodeWriter fromURI(OTPAuthURI uri) {
        Preconditions.checkNotNull((Object)uri);
        return new QRCodeWriter(uri);
    }

    public QRCodeWriter width(int width) {
        this.width = width;
        return this;
    }

    public QRCodeWriter height(int height) {
        this.height = height;
        return this;
    }

    public QRCodeWriter errorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        this.errorCorrectionLevel = errorCorrectionLevel;
        return this;
    }

    public QRCodeWriter margin(int margin) {
        this.margin = margin;
        return this;
    }

    public QRCodeWriter imageFormatName(String imageFormatName) {
        this.imageFormatName = imageFormatName;
        return this;
    }

    public void write(OutputStream os) throws IOException {
        Preconditions.checkNotNull((Object)os);
        this.doWrite(os, null);
    }

    public void write(Path path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        this.doWrite(null, path);
    }

    private void doWrite(OutputStream os, Path path) throws IOException {
        try {
            MultiFormatWriter writer = new MultiFormatWriter();
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
            hints.put(EncodeHintType.MARGIN, this.margin);
            hints.put(EncodeHintType.ERROR_CORRECTION, com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.forBits((int)this.errorCorrectionLevel.getBits()));
            BitMatrix matrix = writer.encode(this.uri.toUriString(), BarcodeFormat.QR_CODE, this.width, this.height, hints);
            if (os != null) {
                MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)this.imageFormatName, (OutputStream)os);
            } else {
                MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)this.imageFormatName, (Path)path);
            }
        }
        catch (WriterException e) {
            throw new IOException(e);
        }
    }

    public static enum ErrorCorrectionLevel {
        L(com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.L.getBits()),
        M(com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.M.getBits()),
        Q(com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.Q.getBits()),
        H(com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.H.getBits());

        private final int bits;

        private ErrorCorrectionLevel(int bits) {
            this.bits = bits;
        }

        private int getBits() {
            return this.bits;
        }
    }
}

