/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Util;
import java.util.HashMap;
import java.util.Map;

public class SpanContext
implements io.opentracing.SpanContext {
    private final long traceId;
    private final long spanId;
    private final Map<String, String> baggage;

    public SpanContext() {
        this(Util.generateRandomGUID(), Util.generateRandomGUID());
    }

    public SpanContext(long traceId, long spanId) {
        this(traceId, spanId, null);
    }

    SpanContext(long traceId) {
        this(traceId, Util.generateRandomGUID());
    }

    SpanContext(long traceId, Map<String, String> baggage) {
        this(traceId, Util.generateRandomGUID(), baggage);
    }

    SpanContext(Long traceId, Long spanId, Map<String, String> baggage) {
        if (traceId == null) {
            traceId = Util.generateRandomGUID();
        }
        if (spanId == null) {
            spanId = Util.generateRandomGUID();
        }
        if (baggage == null) {
            baggage = new HashMap<String, String>();
        }
        this.traceId = traceId;
        this.spanId = spanId;
        this.baggage = baggage;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getTraceId() {
        return this.traceId;
    }

    String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    SpanContext withBaggageItem(String key, String value) {
        this.baggage.put(key, value);
        return new SpanContext(this.getTraceId(), this.getSpanId(), this.baggage);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public com.lightstep.tracer.grpc.SpanContext getInnerSpanCtx() {
        return com.lightstep.tracer.grpc.SpanContext.newBuilder().setTraceId(this.getTraceId()).setSpanId(this.getSpanId()).putAllBaggage(this.baggage).build();
    }
}

