/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.Reference;
import com.lightstep.tracer.grpc.Span;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.NoopSpan;
import com.lightstep.tracer.shared.Span;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Util;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpanBuilder
implements Tracer.SpanBuilder {
    private final String operationName;
    private final Map<String, String> stringTags;
    private final Map<String, Boolean> boolTags;
    private final Map<String, Number> numTags;
    private final AbstractTracer tracer;
    private Long traceId = null;
    private Long spanId = null;
    private SpanContext parent;
    private long startTimestampMicros;
    private boolean ignoringActiveSpan;
    private final Span.Builder grpcSpan = com.lightstep.tracer.grpc.Span.newBuilder();

    SpanBuilder(String operationName, AbstractTracer tracer) {
        this.operationName = operationName;
        this.tracer = tracer;
        this.stringTags = new HashMap<String, String>();
        this.boolTags = new HashMap<String, Boolean>();
        this.numTags = new HashMap<String, Number>();
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
        if (parent == null) {
            return this;
        }
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String type, io.opentracing.SpanContext referredTo) {
        if (referredTo != null && ("child_of".equals(type) || "follows_from".equals(type))) {
            this.parent = (SpanContext)referredTo;
            Reference.Builder refBuilder = Reference.newBuilder();
            refBuilder.setSpanContext(this.parent.getInnerSpanCtx());
            if ("child_of".equals(type)) {
                refBuilder.setRelationship(Reference.Relationship.CHILD_OF);
            } else {
                refBuilder.setRelationship(Reference.Relationship.FOLLOWS_FROM);
            }
            this.grpcSpan.addReferences(refBuilder);
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoringActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.stringTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        this.boolTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        this.numTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTimestampMicros = microseconds;
        return this;
    }

    public Scope startActive(boolean finishOnClose) {
        return this.tracer.scopeManager().activate(this.startManual(), finishOnClose);
    }

    public io.opentracing.Span start() {
        return this.startManual();
    }

    public Tracer.SpanBuilder withTraceIdAndSpanId(long traceId, long spanId) {
        this.traceId = traceId;
        this.spanId = spanId;
        return this;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        return this.parent.baggageItems();
    }

    private SpanContext activeSpanContext() {
        Scope handle = this.tracer.scopeManager().active();
        if (handle == null || handle.span() == null) {
            return null;
        }
        io.opentracing.SpanContext spanContext = handle.span().context();
        if (spanContext instanceof SpanContext) {
            return (SpanContext)spanContext;
        }
        return null;
    }

    public io.opentracing.Span startManual() {
        if (this.tracer.isDisabled()) {
            return NoopSpan.INSTANCE;
        }
        long startTimestampRelativeNanos = -1L;
        if (this.startTimestampMicros == 0L) {
            startTimestampRelativeNanos = System.nanoTime();
            this.startTimestampMicros = Util.nowMicrosApproximate();
        }
        this.grpcSpan.setOperationName(this.operationName);
        this.grpcSpan.setStartTimestamp(Util.epochTimeMicrosToProtoTime(this.startTimestampMicros));
        Long traceId = this.traceId;
        if (this.parent == null && !this.ignoringActiveSpan) {
            this.parent = this.activeSpanContext();
            this.asChildOf(this.parent);
        }
        if (this.parent != null) {
            traceId = this.parent.getTraceId();
        }
        SpanContext newSpanContext = traceId != null && this.spanId != null ? new SpanContext((long)traceId, this.spanId) : (traceId != null ? new SpanContext(traceId) : new SpanContext());
        this.grpcSpan.setSpanContext(newSpanContext.getInnerSpanCtx());
        Span span = new Span(this.tracer, newSpanContext, this.grpcSpan, startTimestampRelativeNanos);
        for (Map.Entry<String, String> entry : this.stringTags.entrySet()) {
            span.setTag(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.boolTags.entrySet()) {
            span.setTag(entry.getKey(), (Boolean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.numTags.entrySet()) {
            span.setTag(entry.getKey(), (Number)entry.getValue());
        }
        return span;
    }
}

