/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import java.util.LinkedList;

class ClockState {
    private static final int maxOffsetAge = 7;
    private final Object mutex = new Object();
    private LinkedList<Sample> samples = new LinkedList();
    private long currentOffsetMicros = 0L;
    private int currentOffsetAge = 8;

    ClockState() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSample(long originMicros, long receiveMicros, long transmitMicros, long destinationMicros) {
        long latestDelayMicros = Long.MAX_VALUE;
        long latestOffsetMicros = 0L;
        if (originMicros > 0L && receiveMicros > 0L && transmitMicros > 0L && destinationMicros > 0L) {
            latestDelayMicros = destinationMicros - originMicros - (transmitMicros - receiveMicros);
            latestOffsetMicros = (receiveMicros - originMicros + (transmitMicros - destinationMicros)) / 2L;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.samples.size() == 8) {
                this.samples.removeFirst();
            }
            this.samples.push(new Sample(latestDelayMicros, latestOffsetMicros));
            ++this.currentOffsetAge;
            this.update();
        }
    }

    private void update() {
        long minDelayMicros = Long.MAX_VALUE;
        long bestOffsetMicros = 0L;
        for (Sample sample : this.samples) {
            if (sample.delayMicros >= minDelayMicros) continue;
            minDelayMicros = sample.delayMicros;
            bestOffsetMicros = sample.offsetMicros;
        }
        if (bestOffsetMicros == this.currentOffsetMicros) {
            return;
        }
        long jitter = 0L;
        for (Sample sample : this.samples) {
            jitter = (long)((double)jitter + Math.pow(bestOffsetMicros - sample.offsetMicros, 2.0));
        }
        jitter = (long)Math.sqrt(jitter / (long)this.samples.size());
        long SGATE = 3L;
        if (this.currentOffsetAge > 7 || Math.abs(this.currentOffsetMicros - bestOffsetMicros) < SGATE * jitter) {
            this.currentOffsetMicros = bestOffsetMicros;
            this.currentOffsetAge = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long offsetMicros() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentOffsetMicros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReady() {
        Object object = this.mutex;
        synchronized (object) {
            return this.samples.size() > 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int activeSampleCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.samples.size();
        }
    }

    private class Sample {
        long delayMicros;
        long offsetMicros;

        Sample(long delayMicros, long offsetMicros) {
            this.delayMicros = delayMicros;
            this.offsetMicros = offsetMicros;
        }
    }

    static class NoopClockState
    extends ClockState {
        NoopClockState() {
        }

        @Override
        void addSample(long o, long r, long t, long d) {
        }

        @Override
        long offsetMicros() {
            return 0L;
        }

        @Override
        boolean isReady() {
            return true;
        }

        @Override
        int activeSampleCount() {
            return 0;
        }
    }
}

