/*
 * Decompiled with CFR 0.152.
 */
package io.netty.karate.resolver;

import io.netty.karate.resolver.HostsFileEntries;
import io.netty.karate.resolver.HostsFileEntriesResolver;
import io.netty.karate.resolver.HostsFileParser;
import io.netty.karate.resolver.ResolvedAddressTypes;
import io.netty.karate.util.CharsetUtil;
import io.netty.karate.util.internal.PlatformDependent;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private final Map<String, Inet4Address> inet4Entries;
    private final Map<String, Inet6Address> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(DefaultHostsFileEntriesResolver.parseEntries());
    }

    DefaultHostsFileEntriesResolver(HostsFileEntries entries) {
        this.inet4Entries = entries.inet4Entries();
        this.inet6Entries = entries.inet6Entries();
    }

    @Override
    public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        String normalized = this.normalize(inetHost);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(normalized);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(normalized);
            }
            case IPV4_PREFERRED: {
                Inet4Address inet4Address = this.inet4Entries.get(normalized);
                return inet4Address != null ? inet4Address : (InetAddress)this.inet6Entries.get(normalized);
            }
            case IPV6_PREFERRED: {
                Inet6Address inet6Address = this.inet6Entries.get(normalized);
                return inet6Address != null ? inet6Address : (InetAddress)this.inet4Entries.get(normalized);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    String normalize(String inetHost) {
        return inetHost.toLowerCase(Locale.ENGLISH);
    }

    private static HostsFileEntries parseEntries() {
        if (PlatformDependent.isWindows()) {
            return HostsFileParser.parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return HostsFileParser.parseSilently();
    }
}

