/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.shell.FileLogAppender;
import com.intuit.karate.shell.StringLogAppender;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public class Command
extends Thread {
    protected static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(Command.class);
    private final File workingDir;
    private final String uniqueName;
    private final Logger logger;
    private final String[] args;
    private final List argList;
    private final boolean sharedAppender;
    private final LogAppender appender;
    private Map<String, String> environment;
    private Process process;
    private int exitCode = -1;
    private static final Set<Integer> PORTS_IN_USE = ConcurrentHashMap.newKeySet();

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public static String exec(boolean useLineFeed, File workingDir, String ... args) {
        Command command = new Command(useLineFeed, workingDir, args);
        command.start();
        command.waitSync();
        return command.appender.collect();
    }

    public static String[] tokenize(String command) {
        StringTokenizer st = new StringTokenizer(command);
        String[] args = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i] = st.nextToken();
            ++i;
        }
        return args;
    }

    public static String execLine(File workingDir, String command) {
        return Command.exec(false, workingDir, Command.tokenize(command));
    }

    public static String getBuildDir() {
        return FileUtils.getBuildDir();
    }

    public static synchronized int getFreePort(int preferred) {
        if (preferred != 0 && PORTS_IN_USE.contains(preferred)) {
            LOGGER.trace("preferred port {} in use (karate), will attempt to find free port ...", (Object)preferred);
            preferred = 0;
        }
        try {
            ServerSocket s = new ServerSocket(preferred);
            int port = s.getLocalPort();
            LOGGER.debug("found / verified free local port: {}", (Object)port);
            s.close();
            PORTS_IN_USE.add(port);
            return port;
        }
        catch (Exception e) {
            if (preferred > 0) {
                LOGGER.trace("preferred port {} in use (system), re-trying ...", (Object)preferred);
                PORTS_IN_USE.add(preferred);
                return Command.getFreePort(0);
            }
            LOGGER.error("failed to find free port: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static boolean waitForHttp(String url) {
        int attempts = 0;
        long startTime = System.currentTimeMillis();
        Http http = Http.forUrl(LogAppender.NO_OP, url);
        do {
            if (attempts > 0) {
                LOGGER.debug("attempt #{} waiting for http to be ready at: {}", (Object)attempts, (Object)url);
            }
            try {
                Http.Response res = http.get();
                int status = res.status();
                if (status == 200) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    LOGGER.debug("ready to accept http connections after {} ms - {}", (Object)elapsedTime, (Object)url);
                    return true;
                }
                LOGGER.warn("http get returned non-ok status: {} - {}", (Object)status, (Object)url);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception ee) {
                    return false;
                }
            }
        } while (attempts++ < 30);
        return false;
    }

    public Command(String ... args) {
        this(false, (Logger)null, (String)null, (String)null, (File)null, args);
    }

    public Command(boolean useLineFeed, File workingDir, String ... args) {
        this(useLineFeed, null, null, null, workingDir, args);
    }

    public Command(boolean useLineFeed, Logger logger, String uniqueName, String logFile, File workingDir, String ... args) {
        this.setDaemon(true);
        this.uniqueName = uniqueName == null ? System.currentTimeMillis() + "" : uniqueName;
        this.setName(this.uniqueName);
        this.logger = logger == null ? new Logger() : logger;
        this.workingDir = workingDir;
        this.args = args;
        if (workingDir != null) {
            workingDir.mkdirs();
        }
        this.argList = Arrays.asList(args);
        if (logFile == null) {
            this.appender = new StringLogAppender(useLineFeed);
            this.sharedAppender = false;
        } else {
            LogAppender temp = this.logger.getAppender();
            boolean bl = this.sharedAppender = temp != null;
            if (this.sharedAppender) {
                this.appender = temp;
            } else {
                this.appender = new FileLogAppender(new File(logFile));
                this.logger.setAppender(this.appender);
            }
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public List getArgList() {
        return this.argList;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int waitSync() {
        try {
            this.join();
            return this.exitCode;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void close(boolean force) {
        LOGGER.debug("closing command: {}", (Object)this.uniqueName);
        if (force) {
            this.process.destroyForcibly();
        } else {
            this.process.destroy();
        }
    }

    @Override
    public void run() {
        try {
            String line;
            this.logger.debug("command: {}", this.argList);
            ProcessBuilder pb = new ProcessBuilder(this.args);
            if (this.environment != null) {
                pb.environment().putAll(this.environment);
                this.environment = pb.environment();
            }
            this.logger.trace("env PATH: {}", pb.environment().get("PATH"));
            if (this.workingDir != null) {
                pb.directory(this.workingDir);
            }
            pb.redirectErrorStream(true);
            this.process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = in.readLine()) != null) {
                this.appender.append(line);
                this.logger.debug("{}", line);
            }
            this.exitCode = this.process.waitFor();
            if (!this.sharedAppender) {
                this.appender.close();
            }
            if (this.exitCode == 0) {
                LOGGER.debug("command complete, exit code: {} - {}", (Object)this.exitCode, (Object)this.argList);
            } else {
                LOGGER.warn("exit code was non-zero: {} - {}", (Object)this.exitCode, (Object)this.argList);
            }
        }
        catch (Exception e) {
            LOGGER.error("command error: {} - {}", (Object)this.argList, (Object)e.getMessage());
        }
    }
}

