/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.NettyUtils;
import com.intuit.karate.netty.ProxyClientHandler;
import com.intuit.karate.netty.ProxyContext;
import com.intuit.karate.netty.ProxyResponse;
import com.intuit.karate.netty.RequestFilter;
import com.intuit.karate.netty.ResponseFilter;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelFutureListener;
import io.netty.karate.channel.ChannelHandlerContext;
import io.netty.karate.channel.SimpleChannelInboundHandler;
import io.netty.karate.handler.codec.http.FullHttpRequest;
import io.netty.karate.handler.codec.http.FullHttpResponse;
import io.netty.karate.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRemoteHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyRemoteHandler.class);
    private final ProxyContext proxyContext;
    private final ProxyClientHandler clientHandler;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final Channel clientChannel;
    private final FullHttpRequest initialRequest;
    protected Channel remoteChannel;
    protected FullHttpRequest currentRequest;

    public ProxyRemoteHandler(ProxyContext proxyContext, ProxyClientHandler clientHandler, FullHttpRequest initialRequest) {
        this.proxyContext = proxyContext;
        this.clientHandler = clientHandler;
        this.clientChannel = clientHandler.clientChannel;
        this.requestFilter = clientHandler.requestFilter;
        this.responseFilter = clientHandler.responseFilter;
        this.initialRequest = initialRequest;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        ProxyResponse filtered;
        if (logger.isTraceEnabled()) {
            logger.debug("<< {}", (Object)response);
        }
        ProxyResponse proxyResponse = filtered = this.responseFilter == null ? null : this.responseFilter.apply(this.proxyContext, this.currentRequest, response);
        if (filtered == null || filtered.response == null) {
            ReferenceCountUtil.retain(response);
        } else {
            response = filtered.response;
            if (logger.isTraceEnabled()) {
                logger.debug("<<<< {}", (Object)response);
            }
        }
        this.clientChannel.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
    }

    protected void send(FullHttpRequest request) {
        FullHttpRequest filtered;
        this.currentRequest = request;
        if (this.requestFilter != null) {
            ProxyResponse pr = this.requestFilter.apply(this.proxyContext, request);
            if (pr != null && pr.response != null) {
                this.clientChannel.writeAndFlush(pr.response);
                return;
            }
            filtered = pr == null ? null : pr.request;
        } else {
            filtered = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(">> before: {}", (Object)request);
        }
        if (filtered == null) {
            ReferenceCountUtil.retain(request);
            filtered = request;
        } else if (logger.isTraceEnabled()) {
            logger.trace(">>>> after: {}", (Object)filtered);
        }
        NettyUtils.fixHeadersForProxy(filtered);
        this.remoteChannel.writeAndFlush(filtered);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.remoteChannel = ctx.channel();
        if (this.initialRequest != null) {
            this.send(this.initialRequest);
            this.clientHandler.unlockAndProceed();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            logger.error("closing proxy outbound connection: {}", (Object)cause.getMessage());
        }
        ctx.close();
        NettyUtils.flushAndClose(this.clientChannel);
    }

    public String toString() {
        return this.remoteChannel + "";
    }
}

