/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.job.ChunkResult;
import com.intuit.karate.job.FeatureScenarios;
import com.intuit.karate.job.JobConfig;
import com.intuit.karate.job.JobServer;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ScenarioJobServer
extends JobServer {
    protected final List<FeatureScenarios> FEATURE_QUEUE = new ArrayList<FeatureScenarios>();
    protected final Map<String, ChunkResult> CHUNK_RESULTS = new HashMap<String, ChunkResult>();
    private final AtomicInteger chunkCounter = new AtomicInteger();

    public ScenarioJobServer(JobConfig config, String reportDir) {
        super(config, reportDir);
    }

    @Override
    public void addFeature(ExecutionContext exec, List<ScenarioExecutionUnit> units, Runnable onComplete) {
        Logger logger = new Logger();
        ArrayList<Scenario> selected = new ArrayList<Scenario>(units.size());
        for (ScenarioExecutionUnit unit : units) {
            if (!FeatureExecutionUnit.isSelected(exec.featureContext, unit.scenario, logger)) continue;
            selected.add(unit.scenario);
        }
        if (selected.isEmpty()) {
            onComplete.run();
        } else {
            FeatureScenarios fs = new FeatureScenarios(exec, selected, onComplete);
            this.FEATURE_QUEUE.add(fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkResult getNextChunk(String executorId) {
        List<FeatureScenarios> list = this.FEATURE_QUEUE;
        synchronized (list) {
            if (this.FEATURE_QUEUE.isEmpty()) {
                return null;
            }
            FeatureScenarios feature = this.FEATURE_QUEUE.get(0);
            Scenario scenario = feature.scenarios.remove(0);
            if (feature.scenarios.isEmpty()) {
                this.FEATURE_QUEUE.remove(0);
            }
            LOGGER.info("features queued: {}", this.FEATURE_QUEUE);
            ChunkResult chunk = new ChunkResult(feature, scenario);
            String chunkId = this.chunkCounter.incrementAndGet() + "";
            chunk.setChunkId(chunkId);
            chunk.setStartTime(System.currentTimeMillis());
            feature.chunks.add(chunk);
            this.CHUNK_RESULTS.put(chunkId, chunk);
            return chunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUpload(File upload, String executorId, String chunkId) {
        File jsonFile = ScenarioJobServer.getFirstFileWithExtension(upload, "json");
        if (jsonFile == null) {
            return;
        }
        String json = FileUtils.toString(jsonFile);
        File videoFile = ScenarioJobServer.getFirstFileWithExtension(upload, "mp4");
        List list = (List)JsonUtils.toJsonDoc(json).read("$[0].elements", new Predicate[0]);
        Map<String, ChunkResult> map = this.CHUNK_RESULTS;
        synchronized (map) {
            ChunkResult cr = this.CHUNK_RESULTS.remove(chunkId);
            LOGGER.info("chunk complete: {}, remaining: {}", (Object)chunkId, this.CHUNK_RESULTS.keySet());
            if (cr == null) {
                LOGGER.error("could not find chunk: {}", (Object)chunkId);
                return;
            }
            ScenarioResult sr = new ScenarioResult(cr.scenario, list, true);
            sr.setStartTime(cr.getStartTime());
            sr.setEndTime(System.currentTimeMillis());
            sr.setThreadName(executorId);
            cr.setResult(sr);
            if (videoFile != null) {
                File dest = new File(FileUtils.getBuildDir() + File.separator + "cucumber-html-reports" + File.separator + chunkId + ".mp4");
                FileUtils.copy(videoFile, dest);
                sr.appendEmbed(Embed.forVideoFile(dest.getName()));
            }
            if (cr.parent.isComplete()) {
                LOGGER.info("feature complete, calling onComplete(): {}", (Object)cr.parent);
                cr.parent.onComplete();
            }
        }
    }
}

