/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JobUtils {
    public static void zip(File src, File dest) {
        try {
            src = src.getCanonicalFile();
            FileOutputStream fos = new FileOutputStream(dest);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            JobUtils.zip(src, "", zipOut, 0);
            zipOut.close();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void zip(File fileToZip, String fileName, ZipOutputStream zipOut, int level) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            String entryName = fileName;
            zipOut.putNextEntry(new ZipEntry(entryName + "/"));
            zipOut.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                String childFileName = childFile.getName();
                if (childFileName.equals("target") || childFileName.equals("build")) continue;
                if (level != 0) {
                    childFileName = entryName + "/" + childFileName;
                }
                JobUtils.zip(childFile, childFileName, zipOut, level + 1);
            }
            return;
        }
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        FileInputStream fis = new FileInputStream(fileToZip);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static void unzip(File src, File dest) {
        try {
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(src));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = JobUtils.createFile(dest, zipEntry);
                boolean isDir = zipEntry.getName().endsWith(File.separator);
                if (isDir) {
                    newFile.mkdirs();
                } else {
                    int len;
                    File parentFile = newFile.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File createFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath)) {
            throw new IOException("entry outside target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

